package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.oa.bean.EmployeeFormalEntity;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.bean.InsurancePaymentApplyEntity;
import com.ejianc.business.oa.service.IEmployeeFormalService;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.service.IInsurancePaymentApplyService;
import com.ejianc.business.warn.api.IWarnSettingApi;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/warn/")
public class WarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String EMPLOYEE_WARN_NAME = "员工入职试用期截止日期预警";
    private static final String EMPLOYEE_FORMAL_WARN_NAME = "员工合同到期日期预警";
    private static final String INSURANCE_WARN_NAME = "保险缴纳到期日期预警";


    private static final String EMPLOYEE_URL = "/ejc-bfyjerp-frontend/#/employeeInto/Card?id=";
    private static final String EMPLOYEE_FORMAL_URL = "/ejc-bfyjerp-frontend/#/employeeFormal/Card?id=";
    private static final String INSURANCE_WARN_URL = "/ejc-bfyjerp-frontend/#/insurancePaymentApply/card?id=";


    @Autowired
    private IEmployeeIntoService employeeIntoService;
    @Autowired
    private IEmployeeFormalService employeeFormalService;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IUserApi userApi;
    @Autowired
    private IInsurancePaymentApplyService insurancePaymentApplyService;

    /**
     * 入职审批 定时预警
     * 试用期截止前10天
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "employeeIntoWarn")
    public CommonResponse<String> employeeIntoWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        Date endDate = DateUtil.addDays(startDate, 10);

        param.getParams().put("try_date", new Parameter(QueryParam.BETWEEN, sim.format(startDate) + "," + sim.format(DateUtil.addDays(endDate, 1))));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        List<EmployeeIntoEntity> entityList = employeeIntoService.queryList(param);

        if (CollectionUtils.isEmpty(entityList)) {
            logger.error("执行" + EMPLOYEE_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("员工入职试用期截止日期预警的数据：{}", JSONObject.toJSONString(entityList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (EmployeeIntoEntity entity : entityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("员工入职审批-" + entity.getName());
            vo.setPcTitle("员工入职审批");
            vo.setPcUrl(EMPLOYEE_URL + entity.getId());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(888888L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList = new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            //发送消息人
            CommonResponse<UserVO> employeeData = userApi.queryUserByUserCode(entity.getCreateUserCode());
            logger.info("employeeData" + JSONObject.toJSONString(employeeData));

            if (employeeData.isSuccess()){
                receiveVO.setName(employeeData.getData().getUserName());//创建人名称
                receiveVO.setNameId(employeeData.getData().getId());//创建人id
            }
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            logger.info("receiveVo" + JSONObject.toJSONString(receiveVO));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
//                    tmpContent
                    tmpContent.replaceAll("#name#", entity.getName())
            );
            resp.add(vo);
        }

        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }



    /**
     * 转正申请 定时预警
     * 合同到期前45天
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "employeeFormalWarn")
    public CommonResponse<String> employeeFormalWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        Date endDate = DateUtil.addDays(startDate, 45);

        param.getParams().put("contract_date_end", new Parameter(QueryParam.BETWEEN, sim.format(startDate) + "," + sim.format(DateUtil.addDays(endDate, 1))));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        List<EmployeeFormalEntity> entityList = employeeFormalService.queryList(param);

        if (CollectionUtils.isEmpty(entityList)) {
            logger.error("执行" + EMPLOYEE_FORMAL_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("员工合同到期日期预警的数据：{}", JSONObject.toJSONString(entityList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (EmployeeFormalEntity entity : entityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("员工转正审批-" + entity.getName());
            vo.setPcTitle("员工入职审批");
            vo.setPcUrl(EMPLOYEE_FORMAL_URL + entity.getId());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(888888L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList = new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            //发送消息人
            CommonResponse<UserVO> employeeData = userApi.queryUserByUserCode(entity.getCreateUserCode());
            if (employeeData.isSuccess()){
                receiveVO.setName(employeeData.getData().getUserName());//创建人名称
                receiveVO.setNameId(employeeData.getData().getId());//创建人id
            }
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
//                    tmpContent
                    tmpContent.replaceAll("#name#", entity.getName())
            );
            resp.add(vo);
        }

        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }




    /**
     * 保险缴纳申请 定时预警
     * 每月15号
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "insuranceApplyWarn")
    public CommonResponse<String> insuranceApplyWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        QueryParam param = new QueryParam();
        param.getParams().put("fees_borne", new Parameter(QueryParam.EQ, "1"));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        List<InsurancePaymentApplyEntity> entityList = insurancePaymentApplyService.queryList(param);
        List<InsurancePaymentApplyEntity> updateEntityList = new ArrayList<>();
        List<InsurancePaymentApplyEntity> warnTwoEntityList = new ArrayList<>();
        List<InsurancePaymentApplyEntity> warnOneEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 0){
            /*
                每月15号做定时任务

                保险缴纳申请
                费用承担情况 -自费

                内容
                判断剩余金额 >= （个人每月承担金额 * 2）
                可以 	剩余金额 = 剩余金额 - 个人每月承担金额
                        累计已扣金额 = 累计已扣金额 + 个人每月承担金额
                不可以	生成预警信息 （人员名称 + 下月保险费用剩余金额不足）（指定角色发信息）
                        在判断 剩余金额 >= 个人每月承担金额
                            可以 	剩余金额 = 剩余金额 - 个人每月承担金额
                                    累计已扣金额 = 累计已扣金额 + 个人每月承担金额
                            不可以	生成预警信息 （人员名称 + 保险扣除失败，剩余金额不足）（指定角色发信息）
             */
            for (InsurancePaymentApplyEntity entity : entityList) {
                if (null != entity.getBalanceMny() && null != entity.getPersonalPayMnyMonth()){
                    if (!(entity.getBalanceMny().compareTo(ComputeUtil.safeMultiply(entity.getPersonalPayMnyMonth(), new BigDecimal(2))) < 0)){
                        //可以
                        entity.setBalanceMny(ComputeUtil.safeSub(entity.getBalanceMny(), entity.getPersonalPayMnyMonth()));
                        entity.setTotalDeductMny(ComputeUtil.safeAdd(entity.getTotalDeductMny(), entity.getPersonalPayMnyMonth()));
                        updateEntityList.add(entity);
                    }else {
                        //不可以
                        warnTwoEntityList.add(entity);
                        if (!(entity.getBalanceMny().compareTo(entity.getPersonalPayMnyMonth()) < 0)){
                            //可以（一个月）
                            entity.setBalanceMny(ComputeUtil.safeSub(entity.getBalanceMny(), entity.getPersonalPayMnyMonth()));
                            entity.setTotalDeductMny(ComputeUtil.safeAdd(entity.getTotalDeductMny(), entity.getPersonalPayMnyMonth()));
                            updateEntityList.add(entity);
                        }else {
                            warnOneEntityList.add(entity);
                        }
                    }
                }
            }
            if (updateEntityList.size() > 0){
                insurancePaymentApplyService.saveOrUpdateBatch(updateEntityList, updateEntityList.size(), false);
                logger.info("员工保险缴纳申请更新数据：{}", JSONObject.toJSONString(updateEntityList));
            }
        }

        if (CollectionUtils.isEmpty(warnTwoEntityList)) {
            logger.error("执行" + INSURANCE_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("员工保险缴纳申请两个月预警的数据：{}", JSONObject.toJSONString(warnTwoEntityList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (InsurancePaymentApplyEntity entity : warnTwoEntityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("保险缴纳申请-" + entity.getPersonName());
            vo.setPcTitle("保险缴纳申请");
            vo.setPcUrl(INSURANCE_WARN_URL + entity.getId());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(888888L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList = new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            //发送消息人
            CommonResponse<UserVO> employeeData = userApi.queryUserByUserCode(entity.getCreateUserCode());
            logger.info("employeeData" + JSONObject.toJSONString(employeeData));

            if (employeeData.isSuccess()){
                receiveVO.setName(employeeData.getData().getUserName());//创建人名称
                receiveVO.setNameId(employeeData.getData().getId());//创建人id
            }
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            logger.info("receiveVo" + JSONObject.toJSONString(receiveVO));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    entity.getPersonName() + "下月保险费用剩余金额不足，请更新保险缴纳申请单！"
//                    tmpContent
//                    tmpContent.replaceAll("#name#", entity.getPersonName())
            );
            resp.add(vo);
        }

        if (CollectionUtils.isEmpty(warnTwoEntityList)) {
            logger.info("执行" + INSURANCE_WARN_NAME + "完成，未发现有匹配两个月预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("员工保险缴纳申请一个月预警的数据：{}", JSONObject.toJSONString(warnOneEntityList));

        //3.筛出符合条件的数据发送信息
        for (InsurancePaymentApplyEntity entity : warnOneEntityList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("保险缴纳申请-" + entity.getPersonName());
            vo.setPcTitle("保险缴纳申请");
            vo.setPcUrl(INSURANCE_WARN_URL + entity.getId());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(888888L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList = new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            //发送消息人
            CommonResponse<UserVO> employeeData = userApi.queryUserByUserCode(entity.getCreateUserCode());
            logger.info("employeeData" + JSONObject.toJSONString(employeeData));

            if (employeeData.isSuccess()){
                receiveVO.setName(employeeData.getData().getUserName());//创建人名称
                receiveVO.setNameId(employeeData.getData().getId());//创建人id
            }
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            logger.info("receiveVo" + JSONObject.toJSONString(receiveVO));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    entity.getPersonName() + "保险扣除失败，剩余金额不足，请更新保险缴纳申请单！"
//                    tmpContent
//                    tmpContent.replaceAll("#name#", entity.getPersonName())
            );
            resp.add(vo);
        }

        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

}
