package com.ejianc.business.tax.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.FinanceAccountVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.*;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tax.bean.CostRatioEntity;
import com.ejianc.business.tax.service.ICostRatioService;
import com.ejianc.business.tax.vo.CostRatioVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 税务管理-成本比例分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costRatio")
public class CostRatioController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICostRatioService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostRatioVO> saveOrUpdate(@RequestBody CostRatioVO saveOrUpdateVO) {
    	CostRatioEntity entity = BeanMapper.map(saveOrUpdateVO, CostRatioEntity.class);
    	service.saveOrUpdate(entity, false);
    	CostRatioVO vo = BeanMapper.map(entity, CostRatioVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostRatioVO> queryDetail(Long id) {
    	CostRatioEntity entity = service.selectById(id);
    	CostRatioVO vo = BeanMapper.map(entity, CostRatioVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostRatioVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CostRatioVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CostRatioVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostRatioVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("businessName","buildDate","year"));
        IPage<CostRatioEntity> page = service.queryPage(param,false);
        IPage<CostRatioVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostRatioVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("businessName","buildDate","year"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CostRatioEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("CostRatio-export.xlsx", beans, response);
    }
    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "CostRatio-import.xlsx", "导入成本比例分析");
    }
    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<CostRatioVO> successList = new ArrayList<>();
            List<CostRatioVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 5) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            for (int i = 0; i < result.size(); i++) {
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                CostRatioVO vo = new CostRatioVO();
                // 企业名称

                String businessName = row.get(0).trim();
                if (StringUtils.isNotBlank(businessName)) {
                    vo.setBusinessName(businessName);
                } else {
                    errMsg.append("`企业名称未填写`");
                }

                String buildDate = row.get(1);
                if (StringUtils.isNotBlank(buildDate)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = new GregorianCalendar(1900,0,-1);
                    Date date = DateUtils.addDays(calendar.getTime(), Integer.valueOf(buildDate));
                    Date parse = null;
  //                  try {
                        //parse = simpleDateFormat.parse(date);
                        vo.setBuildDate(date);
//                    } catch (ParseException e) {
//                        errMsg.append("`成立日期格式错误`");
//                    }
                } else {
                    errMsg.append("`成立日期未填写`");
                }

                String year = row.get(2).trim();
                if (StringUtils.isNotBlank(year)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                    Date parse = null;
                    try {
                        parse = simpleDateFormat.parse(year);
                        vo.setYear(parse);
                    } catch (ParseException e) {
                        errMsg.append("`年份格式错误`");
                    }
                } else {
                    errMsg.append("`年份未填写`");
                }

                // 收入金额
                String incomeMny = row.get(3).trim();
                if (StringUtils.isNotBlank(incomeMny)) {
                    vo.setIncomeMny(ComputeUtil.toBigDecimal(incomeMny));
                } else {
                    errMsg.append("`收入金额未填写`");
                }
                // 成本金额
                String costMny = row.get(4).trim();
                if (StringUtils.isNotBlank(costMny)) {
                    vo.setCostMny(ComputeUtil.toBigDecimal(costMny));
                } else {
                    errMsg.append("`成本金额未填写`");
                }
                vo.setErrMsg(errMsg.toString());
                vo.setRatio(ComputeUtil.bigDecimalPercent(vo.getCostMny(),vo.getIncomeMny(),2));
                if (StringUtils.isNotBlank(vo.getErrMsg())) {
                    errorList.add(vo);
                } else {
                    successList.add(vo);
                }
            }


            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, CostRatioVO.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<CostRatioVO> costRatioVOS) {
        service.saveBatch(BeanMapper.mapList(costRatioVOS, CostRatioEntity.class));
        return CommonResponse.success("导入成功");
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostRatioData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostRatioVO>> refCostRatioData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostRatioEntity> page = service.queryPage(param,false);
        IPage<CostRatioVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostRatioVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

}
