/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.mapper.CheckBfyjMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.CheckItemReformState;
import com.ejianc.business.scene.utils.NoticeEnum;
import com.ejianc.business.scene.utils.OperationState;
import com.ejianc.business.scene.utils.ReformState;
import com.ejianc.business.scene.utils.SubmitState;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkBfyjService")
public class CheckBfyjServiceImpl
extends BaseServiceImpl<CheckBfyjMapper, CheckBfyjEntity>
implements ICheckBfyjService {
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;
    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;
    @Autowired
    private CheckMessageService checkMessageService;

    @Override
    public void checkSubmitHandle(Long billId) {
        if (billId != null) {
            CheckBfyjEntity sceneCheckEntity = (CheckBfyjEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(CheckBfyjEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(CheckBfyjEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(CheckBfyjEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update((Wrapper)updateWrapper);
            List<CheckDetailBfyjEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(CheckDetailBfyjEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(CheckDetailBfyjEntity::getTaskState, (Object)CheckItemReformState.REFORM_STATE.getDescription());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            ArrayList list = new ArrayList();
            List<CheckDetailBfyjEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetaillist.forEach(item -> {
                CheckRecordBfyjEntity sceneCheckRecord = new CheckRecordBfyjEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            this.sceneCheckRecordService.saveBatch(list, list.size());
            sceneCheckEntity = (CheckBfyjEntity)((Object)this.selectById(billId));
            CheckBfyjVO vo = (CheckBfyjVO)BeanMapper.map((Object)((Object)sceneCheckEntity), CheckBfyjVO.class);
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();
            vo.setMsgNum(Integer.valueOf(vo.getSceneCheckDetails().size()));
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());
            if (StringUtils.isNotBlank((CharSequence)reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                this.checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (StringUtils.isNotBlank((CharSequence)notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                this.checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        CheckBfyjEntity sceneCheckEntity = (CheckBfyjEntity)((Object)this.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter("eq", (Object)sceneCheckEntity.getId()));
        param.getParams().put("operationType", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List list = this.sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            CheckBfyjEntity sceneCheckEntity = (CheckBfyjEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(CheckBfyjEntity::getReformStatus, (Object)Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(CheckBfyjEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(CheckBfyjEntity::getReviewStatus, null);
            this.update((Wrapper)updateWrapper);
            List<CheckDetailBfyjEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(CheckDetailBfyjEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(CheckDetailBfyjEntity::getTaskState, (Object)CheckItemReformState.DEFULT_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
            deleteWrapper.eq(CheckRecordBfyjEntity::getCheckId, (Object)sceneCheckEntity.getId());
            deleteWrapper.set(CheckRecordBfyjEntity::getOperationType, (Object)Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            this.sceneCheckRecordService.remove((Wrapper)deleteWrapper);
        }
    }
}

