package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.CheckItemReformState;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.business.scene.vo.CheckRecordBfyjVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Controller
@RequestMapping("reform")
public class ReformController {

    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;

    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;

    @Autowired
    private SessionManager sessionManager;

    @Value("${common.env.base-host}")
    private String baseHost;


    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";//此处需要根据实际修改


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckDetailBfyjVO> queryDetail(@RequestParam Long id) {
        CheckDetailBfyjEntity entity = sceneCheckDetailService.selectById(id);
        //根据检查项id重新查询检查及复查整改记录数，根据创建时间倒序
        Long detailId = entity.getId();
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ, detailId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<CheckRecordBfyjEntity> sceneCheckRecordList = sceneCheckRecordService.queryList(param);
        List<CheckRecordBfyjVO> CheckRecordBfyjVO = BeanMapper.mapList(sceneCheckRecordList, CheckRecordBfyjVO.class);
        CheckDetailBfyjVO vo = BeanMapper.map(entity, CheckDetailBfyjVO.class);
        vo.setSceneCheckRecords(CheckRecordBfyjVO, baseHost);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckDetailBfyjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的

        param.getParams().put("is_reform", new Parameter(QueryParam.IN, Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(),CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        //param.getParams().put("rectification_id",new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getUserId().toString()));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("rectification_id", new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getUserId().toString()));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("rectification_id", new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getEmployeeId().toString()));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        param.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

        //IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<CheckDetailBfyjEntity> page = sceneCheckDetailService.queryPage(param, false);
        IPage<CheckDetailBfyjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckDetailBfyjVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckDetailBfyjVO> saveOrUpdate( @RequestBody CheckDetailBfyjVO saveorUpdateVO) {
        return sceneCheckDetailService.insertOrUpdate(saveorUpdateVO);
    }

}
