package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tax.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 税务管理-收票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity> implements IInvoiceReceiveRegistService{
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "BFYJ_TAX_RECEIVE_POOL";

    @Autowired
    private IBillCodeApi billCodeApi;

    private IOrgApi iOrgApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;


    @Autowired
    private IDefdocApi defdocApi;

    private static final String BILL_CODE = "BFYJ_TAX_RECEIVE_REGIST";

    @Override
    public Boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (null != entity.getContractId() && checkContractId(entity)){
            throw new BusinessException("该合同已有收票登记，请切换合同！");
        }
        if (checkProjectSellerId(entity)){
            throw new BusinessException("该项目+供应商已有收票登记，请切换供应商！");
        }
        int passNum=0;
        if(ListUtil.isNotEmpty(entity.getInvoiceReceivePoolList())){
            CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("bfyj-invoice-type");
            Map<String, String> defMap = getDefMap(defList.getData());

            checkPool(entity.getInvoiceReceivePoolList());

            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceivePoolList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        poolEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List<Long> attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties(entity, poolEntity, "invoiceType", "invoiceTypeName");
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                if (1==poolEntity.getPassFlag()&&!"del".equals(poolEntity.getRowState())){
                    passNum++;
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType()+""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(0);
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setOrgCode(entity.getOrgCode());
                poolEntity.setParentOrgId(entity.getParentOrgId());
                poolEntity.setParentOrgCode(entity.getParentOrgCode());
                poolEntity.setParentOrgName(entity.getParentOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                // 平台优化后，子表创建人编码不自动添加了，这里手动添加下
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            }
        }
        if (passNum>0){
            entity.setPassBoolean(1);
        }else {
            entity.setPassBoolean(0);
        }
        return super.saveOrUpdateNoES(entity);
    }

    private boolean checkProjectSellerId(InvoiceReceiveRegistEntity entity) {
        QueryWrapper<InvoiceReceiveRegistEntity> entityQueryWrapper = new QueryWrapper<>();
        entityQueryWrapper.eq("project_id", entity.getProjectId());
        entityQueryWrapper.eq("seller_id", entity.getSellerId());
        entityQueryWrapper.isNull("contract_id");
        if (null != entity.getId()){
            entityQueryWrapper.ne("id", entity.getId());
        }
        List<InvoiceReceiveRegistEntity> list = super.list(entityQueryWrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            return true;
        }
        return false;
    }

    /**
     * 校验是否存在相同合同的单据
     */
    private boolean checkContractId(InvoiceReceiveRegistEntity entity) {
        QueryWrapper<InvoiceReceiveRegistEntity> entityQueryWrapper = new QueryWrapper<>();
        entityQueryWrapper.eq("contract_id", entity.getContractId());
        if (null != entity.getId()){
            entityQueryWrapper.ne("id", entity.getId());
        }
        List<InvoiceReceiveRegistEntity> list = super.list(entityQueryWrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            return true;
        }
        return false;
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }
    /**
     * 验证发票提交中的发票是否存在重复
     * @param poolList
     */
    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        List<String> invoiceNumberList = new ArrayList<>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            if (!"del".equals(vo.getRowState())) {
                String invoiceNumber = vo.getInvoiceNumber();
                if (StringUtils.isNotEmpty(invoiceNumber)) {
                    if (invoiceNumberList.contains(invoiceNumber)) {
                        throw new BusinessException("发票号码【" + invoiceNumber + "】录入重复！");
                    }
                    invoiceNumberList.add(invoiceNumber);

                    LambdaQueryWrapper<InvoiceReceivePoolEntity> invoiceNumberQueryWrapper = new LambdaQueryWrapper<>();
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, invoiceNumber);
                    invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, vo.getReceiveBillId());
                    int count = invoiceReceivePoolService.count(invoiceNumberQueryWrapper);
                    if (count > 0) {
                        throw new BusinessException("发票号码【" + vo.getInvoiceNumber() + "】已存在！");
                    }
                }
            }

        }
    }

}
