package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.CategoryDocEntity;
import com.ejianc.business.finance.service.ICategoryDocService;
import com.ejianc.business.finance.vo.CategoryDocVO;

/**
 * 出纳资金-报销分类档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("categoryDoc")
public class CategoryDocController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_BXFL_CODE";//此处需要根据实际修改

    @Autowired
    private ICategoryDocService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CategoryDocVO> saveOrUpdate(@RequestBody CategoryDocVO saveOrUpdateVO) {
    	CategoryDocEntity entity = BeanMapper.map(saveOrUpdateVO, CategoryDocEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        switch (entity.getCostType().toString()) {
            case "1":
                entity.setCostTypeName("实地考察费");
                break;
            case "2":
                entity.setCostTypeName("中间费用");
                break;
            case "3":
                entity.setCostTypeName("支付债权对价");
                break;
            case "4":
                entity.setCostTypeName("财务成本");
                break;
            case "5":
                entity.setCostTypeName("司法费用");
                break;
            case "6":
                entity.setCostTypeName("税金");
                break;
            case "7":
                entity.setCostTypeName("提成及奖励");
                break;
        }
    	service.saveOrUpdate(entity, false);
    	CategoryDocVO vo = BeanMapper.map(entity, CategoryDocVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CategoryDocVO> queryDetail(Long id) {
    	CategoryDocEntity entity = service.selectById(id);
    	CategoryDocVO vo = BeanMapper.map(entity, CategoryDocVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CategoryDocVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CategoryDocVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CategoryDocVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CategoryDocVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CategoryDocEntity> page = service.queryPage(param,false);
        IPage<CategoryDocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CategoryDocVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CategoryDocEntity> list = service.queryList(param);
        List<CategoryDocVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,CategoryDocVO.class);
            resList.forEach(e->{
                // 是否属于项目 1-项目，2-公司
                if("1".equals(e.getProjectType())){
                    e.setProjectTypeName("项目");
                }else{
                    e.setProjectTypeName("公司");
                }
                // 状态(0-停用,1-启用)
                if(0==e.getState()){
                    e.setStateName("停用");
                }else{
                    e.setStateName("启用");
                }

                switch (e.getCostType().toString()) {
                    case "1":
                        e.setCostTypeName("实地考察费");
                        break;
                    case "2":
                        e.setCostTypeName("中间费用");
                        break;
                    case "3":
                        e.setCostTypeName("支付债权对价");
                        break;
                    case "4":
                        e.setCostTypeName("财务成本");
                        break;
                    case "5":
                        e.setCostTypeName("司法费用");
                        break;
                    case "6":
                        e.setCostTypeName("税金");
                        break;
                    case "7":
                        e.setCostTypeName("提成及奖励");
                        break;
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-CategoryDoc-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCategoryDocData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CategoryDocVO>> refCategoryDocData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("oneCategory");
        param.getFuzzyFields().add("twoCategory");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("contentCategory");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectType")) {
                String projectType = String.valueOf(_con.get("projectType"));
                param.getParams().put("projectType", new Parameter(QueryParam.EQ, projectType));
            }
        }

        IPage<CategoryDocEntity> page = service.queryPage(param,false);
        IPage<CategoryDocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CategoryDocVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
