package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.ITenderFundsService;
import com.ejianc.business.bid.vo.TenderFundsBackVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.TenderFundsBackMapper;
import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.service.ITenderFundsBackService;

import java.util.List;

/**
 * 投标管理-投标保证金退还
 * 
 * @author generator
 * 
 */
@Service("tenderFundsBackService")
public class TenderFundsBackServiceImpl extends BaseServiceImpl<TenderFundsBackMapper, TenderFundsBackEntity> implements ITenderFundsBackService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITenderFundsService tenderFundsService;

    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/tenderFundsBack/card?id=";

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IBusOpportunityService busOpportunityService;

    @Override
    public List<TenderFundsBackEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<TenderFundsBackEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");

        return super.list(query);
    }

    @Override
    public TenderFundsBackVO saveTenderFundsBack(TenderFundsBackEntity entity) {
        tenderFundsService.saveQuoteBillId(entity.getTenderFundsId(), entity.getId());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, TenderFundsBackVO.class);
    }

    @Override
    public void deleteAllByIds(List<Long> ids) {
        tenderFundsService.delAllQuoteBillId(ids);
        super.removeByIds(ids, false);
    }

    @Override
    public void sendMsgToDocumenter(TenderFundsBackEntity entity) {
        logger.info("开始给资料员发送消息：----");
        String msg = this.sendMsg(entity, "投标保证金已付", entity.getEngineeringName() + "，投标保证金已退！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("开始给资料员发送消息异常：" + msg);
        }
        logger.info("开始给资料员发送消息结束！");
    }

    private String sendMsg(TenderFundsBackEntity entity, String subject, String content) {
        BusOpportunityEntity oppr = busOpportunityService.selectById(entity.getOpportunityId());
        String[] msgRecUserIds = new String[]{oppr.getDocumenterId().toString(), entity.getEmployeeId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
        msgParameter.setPcUrl(PC_URL + entity.getId());

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
