/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.finance.bean.OccupyDetailEntity;
import com.ejianc.business.finance.bean.OccupyEntity;
import com.ejianc.business.finance.mapper.OccupyMapper;
import com.ejianc.business.finance.service.IOccupyService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="occupyService")
public class OccupyServiceImpl
extends BaseServiceImpl<OccupyMapper, OccupyEntity>
implements IOccupyService {
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IProjectBillService projectBillService;

    @Override
    public OccupyVO queryData() {
        OccupyEntity occupyEntity = new OccupyEntity();
        occupyEntity.setId(IdWorker.getId());
        QueryParam param = new QueryParam();
        QueryWrapper queryWrapper = OccupyServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page(1L, -1L);
        List<ProjectDetailBillVO> detailList = this.projectBillService.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        ArrayList<OccupyDetailEntity> occupyDetailEntityList = new ArrayList<OccupyDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<Long, BigDecimal> receiveMap = detailList.stream().filter(item -> null != item.getReceiveMny() && null != item.getProjectId()).collect(Collectors.groupingBy(s -> s.getProjectId(), Collectors.mapping(ProjectDetailBillVO::getReceiveMny, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> paymentMap = detailList.stream().filter(item -> null != item.getPaymentMny() && null != item.getProjectId()).collect(Collectors.groupingBy(s -> s.getProjectId(), Collectors.mapping(ProjectDetailBillVO::getPaymentMny, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, ProjectDetailBillVO> detailMap = detailList.stream().filter(item -> null != item.getProjectId() && null != item.getProjectId()).collect(Collectors.toMap(ProjectDetailBillVO::getProjectId, item -> item, (existing, replacement) -> existing));
            ArrayList<ProjectDetailBillVO> detail = new ArrayList<ProjectDetailBillVO>(detailMap.values());
            detailMap.forEach((projectId, projectDetailBillVO) -> {
                OccupyDetailEntity occupyDetailEntity = new OccupyDetailEntity();
                occupyDetailEntity.setProjectId((Long)projectId);
                occupyDetailEntity.setProjectName(projectDetailBillVO.getProjectName());
                BigDecimal money = ComputeUtil.safeSub((BigDecimal)((BigDecimal)receiveMap.get(projectId)), (BigDecimal)((BigDecimal)paymentMap.get(projectId)));
                occupyDetailEntity.setMoney(money);
                occupyDetailEntity.setId(IdWorker.getId());
                occupyDetailEntity.setMid(occupyEntity.getId());
                occupyDetailEntityList.add(occupyDetailEntity);
            });
            BigDecimal money = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOccupyMny(money);
            LambdaQueryWrapper lambdaLastWrapper = new LambdaQueryWrapper();
            lambdaLastWrapper.in(OccupyEntity::getBillState, new Object[]{1, 3});
            lambdaLastWrapper.orderByDesc(OccupyEntity::getDate);
            List daypayEntityList = super.list((Wrapper)lambdaLastWrapper);
            BigDecimal occupyLastMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)daypayEntityList)) {
                OccupyEntity occupyLastEntity = (OccupyEntity)((Object)daypayEntityList.stream().findFirst().get());
                occupyLastMny = occupyLastEntity.getOccupyMny();
            }
            if (money.compareTo(ComputeUtil.nullToZero((BigDecimal)occupyLastMny)) > -1) {
                occupyEntity.setUpMny(ComputeUtil.safeSub((BigDecimal)money, (BigDecimal)occupyLastMny));
            } else {
                occupyEntity.setDownMny(ComputeUtil.safeSub((BigDecimal)occupyLastMny, (BigDecimal)money));
            }
            occupyEntity.setOccupyDetailList(occupyDetailEntityList);
        }
        OccupyVO occupyVO = (OccupyVO)BeanMapper.map((Object)((Object)occupyEntity), OccupyVO.class);
        return occupyVO;
    }
}

