package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.finance.bean.OccupyDetailEntity;
/**
 * 出纳资金-占用资金表-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_occupy")
public class OccupyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="date")
    private Date date; // 日期
    @TableField(value="occupy_mny")
    private BigDecimal occupyMny; // 资金占用总计金额
    @TableField(value="up_mny")
    private BigDecimal upMny; // 当日资金占用增加
    @TableField(value="down_mny")
    private BigDecimal downMny; // 当日资金占用减少
    @TableField(value="project_mny")
    private BigDecimal projectMny; // 工程款占用合计
    @TableField(value="bail_mny")
    private BigDecimal bailMny; // 保证金占用合计
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 代付材料款占用合计
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其他占用合计
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="occupyDetailService",pidName = "mid")
    private List<OccupyDetailEntity> occupyDetailList = new ArrayList<>(); // 出纳资金-占用资金表-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public BigDecimal getOccupyMny() {
        return occupyMny;
    }

    public void setOccupyMny(BigDecimal occupyMny) {
        this.occupyMny = occupyMny;
    }
    public BigDecimal getUpMny() {
        return upMny;
    }

    public void setUpMny(BigDecimal upMny) {
        this.upMny = upMny;
    }
    public BigDecimal getDownMny() {
        return downMny;
    }

    public void setDownMny(BigDecimal downMny) {
        this.downMny = downMny;
    }
    public BigDecimal getProjectMny() {
        return projectMny;
    }

    public void setProjectMny(BigDecimal projectMny) {
        this.projectMny = projectMny;
    }
    public BigDecimal getBailMny() {
        return bailMny;
    }

    public void setBailMny(BigDecimal bailMny) {
        this.bailMny = bailMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    

    public List<OccupyDetailEntity> getOccupyDetailList() {
        return occupyDetailList;
    }

    public void setOccupyDetailList(List<OccupyDetailEntity> occupyDetailList) {
        this.occupyDetailList = occupyDetailList;
    }
}
