/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.CheckItemReformState;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.business.scene.vo.CheckRecordBfyjVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reform"})
public class ReformController {
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;
    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckDetailBfyjVO> queryDetail(@RequestParam Long id) {
        CheckDetailBfyjEntity entity = (CheckDetailBfyjEntity)((Object)this.sceneCheckDetailService.selectById(id));
        Long detailId = entity.getId();
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)detailId));
        param.getOrderMap().put("createTime", "desc");
        List sceneCheckRecordList = this.sceneCheckRecordService.queryList(param);
        List CheckRecordBfyjVO2 = BeanMapper.mapList((Iterable)sceneCheckRecordList, CheckRecordBfyjVO.class);
        CheckDetailBfyjVO vo = (CheckDetailBfyjVO)BeanMapper.map((Object)((Object)entity), CheckDetailBfyjVO.class);
        vo.setSceneCheckRecords(CheckRecordBfyjVO2, this.baseHost);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckDetailBfyjVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("is_reform", new Parameter("in", Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(), CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("rectification_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getUserId().toString()));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("rectification_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getEmployeeId().toString()));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        param.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        IPage page = this.sceneCheckDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckDetailBfyjVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckDetailBfyjVO> saveOrUpdate(@RequestBody CheckDetailBfyjVO saveorUpdateVO) {
        return this.sceneCheckDetailService.insertOrUpdate(saveorUpdateVO);
    }
}

