package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-员工入职审批表记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_into_record")
public class EmployeeIntoRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 员工id
    @TableField(value="code")
    private String code; // 员工编号
    @TableField(value="name")
    private String name; // 员工名称
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="age")
    private Integer age; // 年龄
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 主职ID
    @TableField(value="post_name")
    private String postName; // 主职
    @TableField(value="rank")
    private Integer rank; // 职级
    @TableField(value="rank_name")
    private String rankName; // 职级
    @TableField(value="nation")
    private String nation; // 民族
    @TableField(value="height")
    private String height; // 身高
    @TableField(value="birth_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    @TableField(value="into_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @TableField(value="try_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDate; // 试用日期
    @TableField(value="origin")
    private String origin; // 籍贯
    @TableField(value="politics_id")
    private Integer politicsId; // 政治面貌
    @TableField(value="politics_name")
    private String politicsName; // 政治面貌
    @TableField(value="marital_status_id")
    private Integer maritalStatusId; // 婚姻状况
    @TableField(value="marital_status_name")
    private String maritalStatusName; // 婚姻状况
    @TableField(value="graduate_school")
    private String graduateSchool; // 毕业院校
    @TableField(value="major")
    private String major; // 所学专业
    @TableField(value="educated")
    private String educated; // 最高学历
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="id_address")
    private String idAddress; // 身份证地址
    @TableField(value="now_address")
    private String nowAddress; // 现居住地址
    @TableField(value="winter_num")
    private BigDecimal winterNum; // 冬季工时
    @TableField(value="summer_num")
    private BigDecimal summerNum; // 夏季工时
    @TableField(value="phone")
    private String phone; // 移动电话
    @TableField(value="email")
    private String email; // 邮箱
    @TableField(value="urgent_name")
    private String urgentName; // 紧急联系人姓名
    @TableField(value="urgent_relational")
    private String urgentRelational; // 紧急联系人关系
    @TableField(value="urgent_phone")
    private String urgentPhone; // 紧急联系人电话
    @TableField(value="salary")
    private BigDecimal salary; // 薪资标准
    @TableField(value="basic_salary")
    private BigDecimal basicSalary; // 基本薪资
    @TableField(value="post_salary")
    private BigDecimal postSalary; // 岗位薪资
    @TableField(value="level_salary")
    private BigDecimal levelSalary; // 层级薪资
    @TableField(value="try_standard")
    private String tryStandard; // 试用标准
    @TableField(value="insured_flag")
    private Integer insuredFlag; // 是否缴纳保险
    @TableField(value="insured_flag_name")
    private String insuredFlagName; // 是否缴纳保险
    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    @TableField(value="educated_salary")
    private BigDecimal educatedSalary; // 学历津贴
    @TableField(value="state")
    private Integer state; // 状态标识（0：离职，1：在职）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本

    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="formal_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date formalDate; // 转正日期
    @TableField(value="contract_term")
    private Integer contractTerm; // 合同年限
    @TableField(value="contract_date_begin")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateBegin; // 合同时间
    @TableField(value="contract_date_end")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateEnd; // 合同时间
    @TableField(value="cert_salary")
    private BigDecimal certSalary; // 证书津贴
    @TableField(value="sport_salary")
    private BigDecimal sportSalary; // 交通补助
    @TableField(value="year_salary_id")
    private Long yearSalaryId; // 司龄津贴
    @TableField(value="year_salary")
    private BigDecimal yearSalary; // 司龄津贴
    @TableField(value="year_change_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date yearChangeDate; // 司龄调整月份
    @TableField(value="remove_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date removeDate; // 实际离职日期
    @TableField(value="salary_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date salaryEndDate; // 薪资核算截止日
    @TableField(value="insured_end_date")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date insuredEndDate; // 保险最后缴纳月份
    @TableField(value="old_dept_id")
    private Long oldDeptId; // 部门ID
    @TableField(value="old_dept_name")
    private String oldDeptName; // 部门
    @TableField(value="old_post_id")
    private Long oldPostId; // 主职ID
    @TableField(value="old_post_name")
    private String oldPostName; // 主职
    @TableField(value="old_rank")
    private Integer oldRank; // 职级
    @TableField(value="old_rank_name")
    private String oldRankName; // 职级
    @TableField(value="old_salary")
    private BigDecimal oldSalary; // 薪资标准
    @TableField(value="old_basic_salary")
    private BigDecimal oldBasicSalary; // 基本薪资
    @TableField(value="old_post_salary")
    private BigDecimal oldPostSalary; // 岗位薪资
    @TableField(value="old_level_salary")
    private BigDecimal oldLevelSalary; // 层级薪资
    @TableField(value="old_cert_salary")
    private BigDecimal oldCertSalary; // 证书津贴
    @TableField(value="old_educated_salary")
    private BigDecimal oldEducatedSalary; // 学历津贴

    @TableField(value="winter_time_start")
    private Date winterTimeStart; // 冬季工时起
    @TableField(value="winter_time_end")
    private Date winterTimeEnd; // 冬季工时止
    @TableField(value="summer_time_start")
    private Date summerTimeStart; // 夏季工时起
    @TableField(value="summer_time_end")
    private Date summerTimeEnd; // 夏季工时止

    @TableField(value="winter_num_select")
    private String winterNumSelect; // 冬季工时 冬季 1：8:30-16:30、 2：9:00-17:00
    @TableField(value="summer_num_select")
    private String summerNumSelect; // 夏季工时 夏季 1：8:30-17:00 、2：9:00-17:00
    @TableField(value="other_need_pay")
    private BigDecimal otherNeedPay; // 其他应付

    public BigDecimal getOtherNeedPay() {
        return otherNeedPay;
    }

    public void setOtherNeedPay(BigDecimal otherNeedPay) {
        this.otherNeedPay = otherNeedPay;
    }

    public String getWinterNumSelect() {
        return winterNumSelect;
    }

    public void setWinterNumSelect(String winterNumSelect) {
        this.winterNumSelect = winterNumSelect;
    }

    public String getSummerNumSelect() {
        return summerNumSelect;
    }

    public void setSummerNumSelect(String summerNumSelect) {
        this.summerNumSelect = summerNumSelect;
    }
    public Date getWinterTimeStart() {
        return winterTimeStart;
    }

    public void setWinterTimeStart(Date winterTimeStart) {
        this.winterTimeStart = winterTimeStart;
    }

    public Date getWinterTimeEnd() {
        return winterTimeEnd;
    }

    public void setWinterTimeEnd(Date winterTimeEnd) {
        this.winterTimeEnd = winterTimeEnd;
    }

    public Date getSummerTimeStart() {
        return summerTimeStart;
    }

    public void setSummerTimeStart(Date summerTimeStart) {
        this.summerTimeStart = summerTimeStart;
    }

    public Date getSummerTimeEnd() {
        return summerTimeEnd;
    }

    public void setSummerTimeEnd(Date summerTimeEnd) {
        this.summerTimeEnd = summerTimeEnd;
    }

    public Date getFormalDate() {
        return formalDate;
    }

    public void setFormalDate(Date formalDate) {
        this.formalDate = formalDate;
    }

    public Integer getContractTerm() {
        return contractTerm;
    }

    public void setContractTerm(Integer contractTerm) {
        this.contractTerm = contractTerm;
    }

    public Date getContractDateBegin() {
        return contractDateBegin;
    }

    public void setContractDateBegin(Date contractDateBegin) {
        this.contractDateBegin = contractDateBegin;
    }

    public Date getContractDateEnd() {
        return contractDateEnd;
    }

    public void setContractDateEnd(Date contractDateEnd) {
        this.contractDateEnd = contractDateEnd;
    }

    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }

    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }

    public Long getYearSalaryId() {
        return yearSalaryId;
    }

    public void setYearSalaryId(Long yearSalaryId) {
        this.yearSalaryId = yearSalaryId;
    }

    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }

    public Date getYearChangeDate() {
        return yearChangeDate;
    }

    public void setYearChangeDate(Date yearChangeDate) {
        this.yearChangeDate = yearChangeDate;
    }

    public Date getRemoveDate() {
        return removeDate;
    }

    public void setRemoveDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public Date getSalaryEndDate() {
        return salaryEndDate;
    }

    public void setSalaryEndDate(Date salaryEndDate) {
        this.salaryEndDate = salaryEndDate;
    }

    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }

    public Long getOldDeptId() {
        return oldDeptId;
    }

    public void setOldDeptId(Long oldDeptId) {
        this.oldDeptId = oldDeptId;
    }

    public String getOldDeptName() {
        return oldDeptName;
    }

    public void setOldDeptName(String oldDeptName) {
        this.oldDeptName = oldDeptName;
    }

    public Long getOldPostId() {
        return oldPostId;
    }

    public void setOldPostId(Long oldPostId) {
        this.oldPostId = oldPostId;
    }

    public String getOldPostName() {
        return oldPostName;
    }

    public void setOldPostName(String oldPostName) {
        this.oldPostName = oldPostName;
    }

    public Integer getOldRank() {
        return oldRank;
    }

    public void setOldRank(Integer oldRank) {
        this.oldRank = oldRank;
    }

    public String getOldRankName() {
        return oldRankName;
    }

    public void setOldRankName(String oldRankName) {
        this.oldRankName = oldRankName;
    }

    public BigDecimal getOldSalary() {
        return oldSalary;
    }

    public void setOldSalary(BigDecimal oldSalary) {
        this.oldSalary = oldSalary;
    }

    public BigDecimal getOldBasicSalary() {
        return oldBasicSalary;
    }

    public void setOldBasicSalary(BigDecimal oldBasicSalary) {
        this.oldBasicSalary = oldBasicSalary;
    }

    public BigDecimal getOldPostSalary() {
        return oldPostSalary;
    }

    public void setOldPostSalary(BigDecimal oldPostSalary) {
        this.oldPostSalary = oldPostSalary;
    }

    public BigDecimal getOldLevelSalary() {
        return oldLevelSalary;
    }

    public void setOldLevelSalary(BigDecimal oldLevelSalary) {
        this.oldLevelSalary = oldLevelSalary;
    }

    public BigDecimal getOldCertSalary() {
        return oldCertSalary;
    }

    public void setOldCertSalary(BigDecimal oldCertSalary) {
        this.oldCertSalary = oldCertSalary;
    }

    public BigDecimal getOldEducatedSalary() {
        return oldEducatedSalary;
    }

    public void setOldEducatedSalary(BigDecimal oldEducatedSalary) {
        this.oldEducatedSalary = oldEducatedSalary;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getTryDate() {
        return tryDate;
    }

    public void setTryDate(Date tryDate) {
        this.tryDate = tryDate;
    }
    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    public Integer getPoliticsId() {
        return politicsId;
    }

    public void setPoliticsId(Integer politicsId) {
        this.politicsId = politicsId;
    }
    public String getPoliticsName() {
        return politicsName;
    }

    public void setPoliticsName(String politicsName) {
        this.politicsName = politicsName;
    }

    public Integer getMaritalStatusId() {
        return maritalStatusId;
    }

    public void setMaritalStatusId(Integer maritalStatusId) {
        this.maritalStatusId = maritalStatusId;
    }

    public String getMaritalStatusName() {
        return maritalStatusName;
    }

    public void setMaritalStatusName(String maritalStatusName) {
        this.maritalStatusName = maritalStatusName;
    }

    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getIdAddress() {
        return idAddress;
    }

    public void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }
    public String getNowAddress() {
        return nowAddress;
    }

    public void setNowAddress(String nowAddress) {
        this.nowAddress = nowAddress;
    }
    public BigDecimal getWinterNum() {
        return winterNum;
    }

    public void setWinterNum(BigDecimal winterNum) {
        this.winterNum = winterNum;
    }
    public BigDecimal getSummerNum() {
        return summerNum;
    }

    public void setSummerNum(BigDecimal summerNum) {
        this.summerNum = summerNum;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
    public String getUrgentName() {
        return urgentName;
    }

    public void setUrgentName(String urgentName) {
        this.urgentName = urgentName;
    }
    public String getUrgentRelational() {
        return urgentRelational;
    }

    public void setUrgentRelational(String urgentRelational) {
        this.urgentRelational = urgentRelational;
    }
    public String getUrgentPhone() {
        return urgentPhone;
    }

    public void setUrgentPhone(String urgentPhone) {
        this.urgentPhone = urgentPhone;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public String getTryStandard() {
        return tryStandard;
    }

    public void setTryStandard(String tryStandard) {
        this.tryStandard = tryStandard;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    
}
