/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service;

import cn.hutool.core.date.DateUtil;
import com.ejianc.business.scene.utils.NoticeEnum;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CheckMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IPushMessageApi pushMessageApi;

    public CommonResponse<String> sendMsg(CheckBfyjVO checkVO, String[] receivers, NoticeEnum notice) {
        if (checkVO != null) {
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= msgId = " + checkVO.getMsgId() + "\uff0cmsgBillCode = " + checkVO.getMsgBillCode() + "\uff0cmsgNum = " + checkVO.getMsgNum() + "========================");
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("weixin");
            channel.add("sys");
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("#NUM#", checkVO.getMsgNum() != null ? String.valueOf(checkVO.getMsgNum()) : null);
            keyMap.put("#BILLCODE#", checkVO.getMsgBillCode());
            keyMap.put("#CHECKNAME#", checkVO.getCheckName());
            keyMap.put("#ID#", String.valueOf(checkVO.getMsgId()));
            keyMap.put("#BASEHOST#", this.baseHost);
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            String subjectExt = "\u3010" + DateUtil.formatDate((Date)checkVO.getCheckDate()) + " " + checkVO.getCheckName() + " (" + checkVO.getCheckTypeName() + ")\u3011";
            parameter.setSubject(notice.getSubject() + subjectExt);
            this.logger.info("==============================\u7cfb\u7edf\u6d88\u606f===================================================");
            String sysContent = NoticeEnum.getPcContent(notice, keyMap);
            this.logger.info("sysContent = " + sysContent);
            parameter.setContent(sysContent);
            parameter.setMobileUrl(NoticeEnum.getMobileUrl(notice, keyMap));
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }
}

