package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.*;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.CheckBfyjMapper;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.service.ICheckBfyjService;

import java.util.ArrayList;
import java.util.List;

/**
 * 现场监控-现场检查
 * 
 * @author generator
 * 
 */
@Service("checkBfyjService")
public class CheckBfyjServiceImpl extends BaseServiceImpl<CheckBfyjMapper, CheckBfyjEntity> implements ICheckBfyjService{
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;

    @Autowired private ICheckRecordBfyjService sceneCheckRecordService;
    @Autowired private CheckMessageService checkMessageService;
    /**
     * 检查单提交后的操作
     *
     * @param billId 检查单id
     */
    @Override
    public void checkSubmitHandle(Long billId) {

        if (billId != null) {
            CheckBfyjEntity sceneCheckEntity = this.selectById(billId);

            // 检查单提交后，修改复查状态为 1
            LambdaUpdateWrapper<CheckBfyjEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CheckBfyjEntity::getId, billId);
            updateWrapper.set(
                    CheckBfyjEntity::getReformStatus, Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(
                    CheckBfyjEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(
                    CheckBfyjEntity::getReviewStatus, Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update(updateWrapper);

            // 检查单提交后 检查项状态改为待整改
            List<CheckDetailBfyjEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(
                    d -> {
                        LambdaUpdateWrapper<CheckDetailBfyjEntity> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.eq(CheckDetailBfyjEntity::getId, d.getId());
                        wrapper.set(
                                CheckDetailBfyjEntity::getIsReform,
                                Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                        wrapper.set(
                                CheckDetailBfyjEntity::getTaskState,
                                CheckItemReformState.REFORM_STATE.getDescription());
                        sceneCheckDetailService.update(wrapper);
                    });

            List<CheckRecordBfyjEntity> list = new ArrayList<>();
            List<CheckDetailBfyjEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            // 检查单提交后，生成检查信息记录
            sceneCheckDetaillist.forEach(
                    item -> {
                        CheckRecordBfyjEntity sceneCheckRecord = new CheckRecordBfyjEntity();
                        sceneCheckRecord.setPid(item.getId());
                        sceneCheckRecord.setCheckId(item.getPid());
                        // 设置操作状态
                        sceneCheckRecord.setOperationType(
                                Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                        sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                        sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                        sceneCheckRecord.setReviewResult(item.getReviewResult());
                        sceneCheckRecord.setImgIds(item.getProblemImgIds());
                        sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                        sceneCheckRecord.setCheckItem(item.getCheckItem());
                        sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                        sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                        list.add(sceneCheckRecord);
                    });
            sceneCheckRecordService.saveBatch(list, list.size());

            sceneCheckEntity = this.selectById(billId);
            CheckBfyjVO vo = BeanMapper.map(sceneCheckEntity, CheckBfyjVO.class);
            // 待整改检查项发 送消息
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();

            vo.setMsgNum(vo.getSceneCheckDetails().size());
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());

            if (StringUtils.isNotBlank(reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                // 发送消息给整改人
                checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (StringUtils.isNotBlank(notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                // 发送消息给需要通知人员
                checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    /**
     * 检查单弃审前的操作
     *
     * @param billId
     */
    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        // 检查单弃审前，查询记录表中是否有整改记录
        CheckBfyjEntity sceneCheckEntity = this.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter(QueryParam.EQ, sceneCheckEntity.getId()));
        param.getParams().put(
                "operationType",
                new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List<CheckRecordBfyjEntity> list = sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    /**
     * 检查单弃审后操作
     *
     * @param billId 单据id
     */
    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            CheckBfyjEntity sceneCheckEntity = this.selectById(billId);
            // 检查单弃审后，修改复查状态为 0
            LambdaUpdateWrapper<CheckBfyjEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CheckBfyjEntity::getId, billId);
            updateWrapper.set(
                    CheckBfyjEntity::getReformStatus, Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(
                    CheckBfyjEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(CheckBfyjEntity::getReviewStatus, null);
            this.update(updateWrapper);

            // 检查单弃审后 检查项状态改为默认值 0
            List<CheckDetailBfyjEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(
                    d -> {
                        LambdaUpdateWrapper<CheckDetailBfyjEntity> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.eq(CheckDetailBfyjEntity::getId, d.getId());
                        wrapper.set(
                                CheckDetailBfyjEntity::getIsReform,
                                Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                        wrapper.set(
                                CheckDetailBfyjEntity::getTaskState, CheckItemReformState.DEFULT_STATE.getCode());
                        sceneCheckDetailService.update(wrapper);
                    });

            // 检查单弃审后，要删除记录表中检查单的检查记录  检查单id 和 操作类型为检查
            LambdaUpdateWrapper<CheckRecordBfyjEntity> deleteWrapper = new LambdaUpdateWrapper<>();
            deleteWrapper.eq(CheckRecordBfyjEntity::getCheckId, sceneCheckEntity.getId());
            deleteWrapper.set(
                    CheckRecordBfyjEntity::getOperationType,
                    Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            sceneCheckRecordService.remove(deleteWrapper);
        }
    }

}
