package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 资产管理-项目尽调
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asset_project_check")
public class ProjectCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="business_source")
    private String businessSource; // 业务来源
    @TableField(value="charge_person_id")
    private Long chargePersonId; // 跟踪负责人
    @TableField(value="charge_person_name")
    private String chargePersonName; // 跟踪负责人名称
    @TableField(value="check_cycle")
    private String checkCycle; // 尽调周期
    @TableField(value="bottom_property_position")
    private String bottomPropertyPosition; // 底层资产位置
    @TableField(value="property_type")
    private String propertyType; // 资产类别
    @TableField(value="area")
    private String area; // 面积
    @TableField(value="debt_person")
    private String debtPerson; // 债务人
    @TableField(value="claim_person")
    private String claimPerson; // 债权人
    @TableField(value="claim_target")
    private String claimTarget; // 债券标的
    @TableField(value="mortgage_close_situation")
    private String mortgageCloseSituation; // 抵押及查封情况
    @TableField(value="invest_consideration")
    private String investConsideration; // 拟投资对价
    @TableField(value="asset_allocation_flag")
    private Integer assetAllocationFlag; // 是否配资(1:是，0：否)
    @TableField(value="actual_invest_quota")
    private String actualInvestQuota; // 我方实际投资额
    @TableField(value="invest_cycle")
    private String investCycle; // 投资周期
    @TableField(value="predict_cash_payment")
    private String predictCashPayment; // 预期变现回款
    @TableField(value="tax_cost_predict")
    private String taxCostPredict; // 税费成本预估
    @TableField(value="other_fee_predict")
    private String otherFeePredict; // 其他费用预估
    @TableField(value="finance_cost_predict")
    private String financeCostPredict; // 财务成本预估
    @TableField(value="profit_predict")
    private String profitPredict; // 净利润预估
    @TableField(value="profit_rate_predict")
    private String profitRatePredict; // 利润率预估
    @TableField(value="year_profit_rate_predict")
    private String yearProfitRatePredict; // 年化平均利润率预估
    @TableField(value="submit_report_flag")
    private Integer submitReportFlag; // 是否提交尽调报告(1:是，0：否)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBusinessSource() {
        return businessSource;
    }

    public void setBusinessSource(String businessSource) {
        this.businessSource = businessSource;
    }
    public Long getChargePersonId() {
        return chargePersonId;
    }

    public void setChargePersonId(Long chargePersonId) {
        this.chargePersonId = chargePersonId;
    }
    public String getChargePersonName() {
        return chargePersonName;
    }

    public void setChargePersonName(String chargePersonName) {
        this.chargePersonName = chargePersonName;
    }
    public String getCheckCycle() {
        return checkCycle;
    }

    public void setCheckCycle(String checkCycle) {
        this.checkCycle = checkCycle;
    }
    public String getBottomPropertyPosition() {
        return bottomPropertyPosition;
    }

    public void setBottomPropertyPosition(String bottomPropertyPosition) {
        this.bottomPropertyPosition = bottomPropertyPosition;
    }
    public String getPropertyType() {
        return propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getDebtPerson() {
        return debtPerson;
    }

    public void setDebtPerson(String debtPerson) {
        this.debtPerson = debtPerson;
    }
    public String getClaimPerson() {
        return claimPerson;
    }

    public void setClaimPerson(String claimPerson) {
        this.claimPerson = claimPerson;
    }
    public String getClaimTarget() {
        return claimTarget;
    }

    public void setClaimTarget(String claimTarget) {
        this.claimTarget = claimTarget;
    }
    public String getMortgageCloseSituation() {
        return mortgageCloseSituation;
    }

    public void setMortgageCloseSituation(String mortgageCloseSituation) {
        this.mortgageCloseSituation = mortgageCloseSituation;
    }
    public String getInvestConsideration() {
        return investConsideration;
    }

    public void setInvestConsideration(String investConsideration) {
        this.investConsideration = investConsideration;
    }
    public Integer getAssetAllocationFlag() {
        return assetAllocationFlag;
    }

    public void setAssetAllocationFlag(Integer assetAllocationFlag) {
        this.assetAllocationFlag = assetAllocationFlag;
    }
    public String getActualInvestQuota() {
        return actualInvestQuota;
    }

    public void setActualInvestQuota(String actualInvestQuota) {
        this.actualInvestQuota = actualInvestQuota;
    }
    public String getInvestCycle() {
        return investCycle;
    }

    public void setInvestCycle(String investCycle) {
        this.investCycle = investCycle;
    }
    public String getPredictCashPayment() {
        return predictCashPayment;
    }

    public void setPredictCashPayment(String predictCashPayment) {
        this.predictCashPayment = predictCashPayment;
    }
    public String getTaxCostPredict() {
        return taxCostPredict;
    }

    public void setTaxCostPredict(String taxCostPredict) {
        this.taxCostPredict = taxCostPredict;
    }
    public String getOtherFeePredict() {
        return otherFeePredict;
    }

    public void setOtherFeePredict(String otherFeePredict) {
        this.otherFeePredict = otherFeePredict;
    }
    public String getFinanceCostPredict() {
        return financeCostPredict;
    }

    public void setFinanceCostPredict(String financeCostPredict) {
        this.financeCostPredict = financeCostPredict;
    }
    public String getProfitPredict() {
        return profitPredict;
    }

    public void setProfitPredict(String profitPredict) {
        this.profitPredict = profitPredict;
    }
    public String getProfitRatePredict() {
        return profitRatePredict;
    }

    public void setProfitRatePredict(String profitRatePredict) {
        this.profitRatePredict = profitRatePredict;
    }
    public String getYearProfitRatePredict() {
        return yearProfitRatePredict;
    }

    public void setYearProfitRatePredict(String yearProfitRatePredict) {
        this.yearProfitRatePredict = yearProfitRatePredict;
    }
    public Integer getSubmitReportFlag() {
        return submitReportFlag;
    }

    public void setSubmitReportFlag(Integer submitReportFlag) {
        this.submitReportFlag = submitReportFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
}
