/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.oa.bean.InstoreDetailEntity;
import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.bean.OutstoreDetailEntity;
import com.ejianc.business.oa.mapper.InstoreMapper;
import com.ejianc.business.oa.service.IInstoreDetailService;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.service.IOutstoreDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreService")
public class InstoreServiceImpl
extends BaseServiceImpl<InstoreMapper, InstoreEntity>
implements IInstoreService {
    @Autowired
    private IInstoreDetailService instoreDetailService;
    @Autowired
    private IOutstoreDetailService outstoreDetailService;

    @Override
    public BigDecimal calculateCanUseNum(Long inStoreSubId, Long materialId, Long outSubId) {
        InstoreDetailEntity inEntity = (InstoreDetailEntity)((Object)this.instoreDetailService.selectById(inStoreSubId));
        if (inEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8be5\u7269\u8d44\u5165\u5e93\u8bb0\u5f55\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceSubId", new Parameter("eq", (Object)inStoreSubId));
        List subs = this.outstoreDetailService.queryList(queryParam, false);
        BigDecimal canUseNum = inEntity.getInstoreNumber();
        BigDecimal cannotUseNum = BigDecimal.ZERO;
        if (!ListUtil.isEmpty((List)subs)) {
            for (OutstoreDetailEntity s : subs) {
                if (outSubId != null && Objects.equals(outSubId, s.getId())) continue;
                cannotUseNum = ComputeUtil.safeAdd((BigDecimal)cannotUseNum, (BigDecimal)s.getOutStoreNumber());
            }
        }
        canUseNum = ComputeUtil.safeSub((BigDecimal)canUseNum, (BigDecimal)cannotUseNum);
        return canUseNum;
    }

    @Override
    public Map<Long, BigDecimal> calNowNumber(Long storeId, List<Long> materialIds) {
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        List<JSONObject> resultList = ((InstoreMapper)this.baseMapper).calNowNumber(storeId, materialIds);
        if (CollectionUtils.isNotEmpty(resultList)) {
            map = resultList.stream().collect(Collectors.toMap(item -> Long.valueOf(item.get((Object)"materialId").toString()), item -> ComputeUtil.toBigDecimal((String)item.get((Object)"nowNumber").toString())));
        }
        return map;
    }
}

