/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.oa.bean.InsurancePaymentApplyEntity;
import com.ejianc.business.oa.service.IInsurancePaymentApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receive")
public class ReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IInsurancePaymentApplyService insurancePaymentApplyService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReceiveInvoiceService invoiceService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        if ("\u81ea\u8d39\u4fdd\u9669".equals(entity.getReceiveKindName())) {
            InsurancePaymentApplyEntity insurancePaymentApplyEntity = (InsurancePaymentApplyEntity)((Object)this.insurancePaymentApplyService.selectById(entity.getEmployeeId()));
            if (null != insurancePaymentApplyEntity) {
                insurancePaymentApplyEntity.setRecedExternalMny(ComputeUtil.safeAdd((BigDecimal)insurancePaymentApplyEntity.getRecedExternalMny(), (BigDecimal)entity.getReceiveMny()));
                insurancePaymentApplyEntity.setBalanceMny(ComputeUtil.safeSub((BigDecimal)insurancePaymentApplyEntity.getRecedExternalMny(), (BigDecimal)insurancePaymentApplyEntity.getTotalDeductMny()));
                this.logger.info("\u66f4\u65b0\u4fdd\u9669\u7f34\u7eb3\u7533\u8bf7\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)insurancePaymentApplyEntity)));
            }
            this.insurancePaymentApplyService.saveOrUpdate((Object)insurancePaymentApplyEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        if (!this.validateCreateTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u540e\u7eed\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u652f\u51fa\u5355\u636e\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u64a4\u56de\u64cd\u4f5c!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = (ReceiveEntity)((Object)this.receiveService.selectById(billId));
        if ("\u81ea\u8d39\u4fdd\u9669".equals(entity.getReceiveKindName())) {
            InsurancePaymentApplyEntity insurancePaymentApplyEntity = (InsurancePaymentApplyEntity)((Object)this.insurancePaymentApplyService.selectById(entity.getEmployeeId()));
            if (null != insurancePaymentApplyEntity) {
                insurancePaymentApplyEntity.setRecedExternalMny(ComputeUtil.safeSub((BigDecimal)insurancePaymentApplyEntity.getRecedExternalMny(), (BigDecimal)entity.getReceiveMny()));
                insurancePaymentApplyEntity.setBalanceMny(ComputeUtil.safeSub((BigDecimal)insurancePaymentApplyEntity.getRecedExternalMny(), (BigDecimal)insurancePaymentApplyEntity.getTotalDeductMny()));
                this.logger.info("\u66f4\u65b0\u4fdd\u9669\u7f34\u7eb3\u7533\u8bf7\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)insurancePaymentApplyEntity)));
            }
            this.insurancePaymentApplyService.saveOrUpdate((Object)insurancePaymentApplyEntity, false);
        }
        return CommonResponse.success();
    }

    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"create_time", (Object)createTime);
        List list = this.receiveService.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

