/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.WinningRegistrationEntity;
import com.ejianc.business.bid.service.IWinningRegistrationService;
import com.ejianc.business.cost.bean.OfficeMemberDetailEntity;
import com.ejianc.business.cost.bean.OfficeMemberEntity;
import com.ejianc.business.cost.service.IOfficeMemberDetailService;
import com.ejianc.business.cost.service.IOfficeMemberService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="winningRegistration")
public class WinningRegistrationBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IWinningRegistrationService service;
    @Autowired
    private IOfficeMemberService officeMemberService;
    @Autowired
    private IOfficeMemberDetailService officeMemberDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        WinningRegistrationEntity entity = (WinningRegistrationEntity)((Object)this.service.selectById(billId));
        Long affiliateMemberId = entity.getAffiliateMemberId();
        OfficeMemberEntity officeMemberEntity = (OfficeMemberEntity)((Object)this.officeMemberService.selectById(affiliateMemberId));
        if (null != officeMemberEntity) {
            List<OfficeMemberDetailEntity> detailList = officeMemberEntity.getDetailList();
            OfficeMemberDetailEntity officeMemberDetailEntity = new OfficeMemberDetailEntity();
            officeMemberDetailEntity.setDetailBidDate(entity.getBidDate());
            officeMemberDetailEntity.setDetailBidMny(entity.getBidMny());
            officeMemberDetailEntity.setDetailBidProjectId(entity.getOpportunityId());
            officeMemberDetailEntity.setDetailBidProjectName(entity.getEngineeringName());
            officeMemberDetailEntity.setSourceId(entity.getId());
            officeMemberDetailEntity.setPid(officeMemberEntity.getId());
            detailList.add(officeMemberDetailEntity);
            int size = detailList.size();
            BigDecimal bidMny = detailList.stream().filter(item -> null != item.getDetailBidMny()).map(OfficeMemberDetailEntity::getDetailBidMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            officeMemberEntity.setCooperationBidNum(String.valueOf(size));
            officeMemberEntity.setCooperationBidOutputMny(bidMny);
            this.officeMemberService.saveOrUpdate((Object)officeMemberEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        WinningRegistrationEntity entity = (WinningRegistrationEntity)((Object)this.service.selectById(billId));
        Long affiliateMemberId = entity.getAffiliateMemberId();
        OfficeMemberEntity officeMemberEntity = (OfficeMemberEntity)((Object)this.officeMemberService.selectById(affiliateMemberId));
        if (null != officeMemberEntity) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)updateWrapper.eq(OfficeMemberDetailEntity::getSourceId, (Object)billId)).set(BaseEntity::getDr, (Object)1);
            this.officeMemberDetailService.update((Wrapper)updateWrapper);
            officeMemberEntity.setCooperationBidNum(Integer.valueOf(officeMemberEntity.getCooperationBidNum()) > 0 ? String.valueOf(Integer.valueOf(officeMemberEntity.getCooperationBidNum()) - 1) : null);
            officeMemberEntity.setCooperationBidOutputMny(ComputeUtil.safeSub((BigDecimal)officeMemberEntity.getCooperationBidOutputMny(), (BigDecimal)entity.getBidMny()));
            this.officeMemberService.saveOrUpdate((Object)officeMemberEntity);
        }
        return CommonResponse.success();
    }
}

