package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.oa.bean.YearSalaryEntity;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.service.IYearSalaryService;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.business.oa.vo.PayrollDetailImportVO;
import com.ejianc.business.oa.vo.PayrollDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.PayrollMapper;
import com.ejianc.business.oa.bean.PayrollEntity;
import com.ejianc.business.oa.service.IPayrollService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力行政-工资表
 * 
 * @author generator
 * 
 */
@Service("payrollService")
public class PayrollServiceImpl extends BaseServiceImpl<PayrollMapper, PayrollEntity> implements IPayrollService{

    @Autowired
    private IEmployeeIntoService employeeIntoService;
    @Autowired
    private IYearSalaryService yearSalaryService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Map<String, String[]> parameterMap = multipartRequest.getParameterMap();
        String monthMain = parameterMap.get("month")[0];
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PayrollDetailImportVO> successList = new ArrayList<>();
            List<PayrollDetailImportVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
//                if (result.get(0).size() != 16) {
//                    throw new BusinessException("请按照导入模板导入数据");
//                }
                if (result.size() >= 1000) {
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                //获取全部人员
                List<EmployeeIntoVO> employeeList = employeeIntoService.queryEmployeeData();
                if (CollectionUtils.isEmpty(employeeList)){
                    throw new BusinessException("请添加入职申请人员！");
                }

                Map<String, EmployeeIntoVO> employeeMap = employeeList.stream().filter(e -> null != e.getIdCard()).collect(Collectors.toMap(e -> e.getIdCard(), e -> e,
                        (existing, replacement) -> replacement));
                //查询司龄档案信息
                LambdaQueryWrapper<YearSalaryEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
                lambdaQueryWrapper.eq(YearSalaryEntity::getDr,0);
                List<YearSalaryEntity> yearSalaryEntityList = yearSalaryService.list(lambdaQueryWrapper);
                Map<Integer, Map<String, BigDecimal>> yearMap = yearSalaryEntityList.stream().collect(Collectors.groupingBy(YearSalaryEntity::getRank
                        , Collectors.toMap(YearSalaryEntity::getYear, YearSalaryEntity::getSalary, (existing, replacement) -> replacement)));
                List<PayrollDetailVO> lastDetailList = baseMapper.queryAllLastDetail();
                Map<String, BigDecimal> lastDetailMap = lastDetailList.stream().collect(Collectors.toMap(PayrollDetailVO::getIdCard, PayrollDetailVO::getSalaryMny
                        , (existing, replacement) -> replacement));

                for (int i = 3; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    PayrollDetailImportVO importVO = new PayrollDetailImportVO();

                    //身份证号
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[身份证号为必填项]");
                    } else {
                        if (datas.get(1).length() > 200) {
                            importVO.setErrorMessage("填写身份证号长度为1~200字");
                        }
                        if (employeeMap.containsKey(datas.get(1).trim())){
                            EmployeeIntoVO employeeIntoVO = employeeMap.get(datas.get(1).trim());
                            importVO = BeanMapper.map(employeeIntoVO, PayrollDetailImportVO.class);
                            importVO.setOtherPayMny(null!=employeeIntoVO.getOtherNeedPay()?employeeIntoVO.getOtherNeedPay():BigDecimal.ZERO);
                            importVO.setOtherDeductMny(BigDecimal.ZERO);
                            importVO.setEmployeeId(employeeIntoVO.getId());
                        }else {
                            continue;
                        }
                    }

                    //工作时长    计薪工时
                    if (StringUtils.isNotBlank(datas.get(64))) {
                        importVO.setSalaryTime(new BigDecimal(datas.get(64).trim()));
                    }


                    BigDecimal noClockTime = BigDecimal.ZERO;
                    //缺卡次数
                    if (StringUtils.isNotBlank(datas.get(17))) {
                        noClockTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(17).trim()), noClockTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(18))) {
                        noClockTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(18).trim()), noClockTime);
                    }
                    importVO.setNoClockTime(noClockTime);

                    //旷工工时
                    //todo: 一天按8小时算 后续修改
                    if (StringUtils.isNotBlank(datas.get(19))) {
                        importVO.setAbsenteeTime(ComputeUtil.safeMultiply(new BigDecimal(datas.get(19).trim()), new BigDecimal(8)));
                    }


                    //事假
                    if (StringUtils.isNotBlank(datas.get(22))) {
                        importVO.setThingTime(new BigDecimal(datas.get(22).trim()));
                    }
                    //病假工时
                    if (StringUtils.isNotBlank(datas.get(24))) {
                        importVO.setIllnessTime(new BigDecimal(datas.get(24).trim()));
                    }
                    BigDecimal marryTime = BigDecimal.ZERO;
                    //婚假、产假、哺乳假、丧假
                    if (StringUtils.isNotBlank(datas.get(26))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(26).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(28))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(28).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(30))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(30).trim()), marryTime);
                    }
                    if (StringUtils.isNotBlank(datas.get(31))) {
                        marryTime = ComputeUtil.safeAdd(new BigDecimal(datas.get(31).trim()), marryTime);
                    }
                    importVO.setMarryTime(ComputeUtil.safeAdd(marryTime));


                    //算司龄
                    importVO.setYearSalary(this.calYearSalary(importVO,employeeMap.get(datas.get(1).trim()),monthMain,yearMap,lastDetailMap));

                    //基本工资+岗位工资+层级工资+交通+司龄
                    BigDecimal basicSalary = ComputeUtil.safeAdd(importVO.getBasicSalary(), importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary());

                    // 计算扣款
                    if (null != importVO.getSalaryTime() && importVO.getSalaryTime().compareTo(BigDecimal.ZERO) > 0){
                        //计时工薪
                        BigDecimal hourSalary = importVO.getSalaryTime().setScale(2, BigDecimal.ROUND_HALF_UP);
                        //（岗位工资+层级工资+其他应付+交通+司龄）
                        BigDecimal mny = ComputeUtil.safeAdd(importVO.getPostSalary(), importVO.getLevelSalary(),importVO.getOtherPayMny()
                                ,importVO.getSportSalary(),importVO.getYearSalary()).setScale(2, BigDecimal.ROUND_HALF_UP);

                        //事假扣款计算：（基本工资+岗位工资+层级工资+其他应付+交通+司龄）/计时工薪*事假工时
                        if (null != importVO.getThingTime() && importVO.getThingTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setThingTimeDeduct(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeAdd(mny,importVO.getBasicSalary()),
                                    hourSalary),importVO.getThingTime())
                            .setScale(2, BigDecimal.ROUND_HALF_UP));
                        }

                        //旷工：（基本工资+岗位工资+层级工资+其他应付+交通+司龄）/计时工薪 * 矿工工时*3
                        if (null != importVO.getAbsenteeTime() && importVO.getAbsenteeTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setAbsenteeTimeDeduct( ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeAdd(mny,importVO.getBasicSalary()),hourSalary)
                                    ,  new BigDecimal(3),importVO.getAbsenteeTime()
                            .setScale(2, BigDecimal.ROUND_HALF_UP)));
                        }

                        //单次未打卡：（基本工资+岗位工资+层级工资+其它应付+交通+司龄）/21.75*3*（上班缺卡次数+下班缺卡次数）
                        if (null != importVO.getNoClockTime() && importVO.getNoClockTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setNoClockTimeDeduct( ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeAdd(mny,importVO.getBasicSalary()),
                                   new BigDecimal(21.75)), new BigDecimal(3),importVO.getNoClockTime())
                            .setScale(2, BigDecimal.ROUND_HALF_UP));
                        }


                        //病假扣款计算：（岗位工资+层级工资+交通+司龄）/计时工薪*病假工时
                        if (null != importVO.getIllnessTime() && importVO.getIllnessTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setIllnessTimeDeduct(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(mny, importVO.getSalaryTime())
                                    , importVO.getIllnessTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }


                        //婚假、产假、哺乳假、丧假：交通补助/计时工薪*对应假工时
                        if (null != importVO.getMarryTime() && importVO.getMarryTime().compareTo(BigDecimal.ZERO) > 0){
                            importVO.setMarryTimeDeduct(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(importVO.getSportSalary(), importVO.getSalaryTime()),
                                    importVO.getMarryTime()).setScale(2, BigDecimal.ROUND_HALF_UP));
                        }

                        //todo:迟到？

                        //考勤扣款
                        importVO.setAttendanceDeduct(ComputeUtil.safeAdd(importVO.getThingTimeDeduct(), importVO.getIllnessTimeDeduct(), importVO.getMarryTimeDeduct(), importVO.getAbsenteeTimeDeduct(), importVO.getNoClockTimeDeduct()));

                    }
                    importVO.setSalaryMny(ComputeUtil.safeSub(ComputeUtil.safeAdd(importVO.getBasicSalary(), importVO.getPostSalary(), importVO.getLevelSalary(), importVO.getSportSalary(), importVO.getYearSalary(), importVO.getEducatedSalary(),importVO.getOtherPayMny()), importVO.getAttendanceDeduct()));
                    importVO.setActualSalaryMny(ComputeUtil.safeSub(importVO.getSalaryMny(), importVO.getEndownmentPersonMny(), importVO.getUnemployeePersonMny(), importVO.getBaseMedicalPersonMny()));


                    importVO.setId(IdWorker.getId());


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    } else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    //计算司龄
    private BigDecimal calYearSalary(PayrollDetailImportVO importVO, EmployeeIntoVO employeeIntoVO,String monMain,Map<Integer, Map<String, BigDecimal>> yearMap,Map<String, BigDecimal> lastDetailMap) {
        //转正次月视为司龄满一年。
        //举例：2024年9月转正，初始司龄0
        //在2025年10月1日开始以后的查询，司龄为1
        //在2026年10月1日开始以后的查询，司龄为2
        /*
            司龄每年对应的补助
            高层、中层	基层
            1年250	1年200
            2年200	2年150
            3年150	3年100
            4年100	4年50
            5年100	5年50
            6年100	6年50
            7年100	7年50
            8年150	8年100
            9年200	9年150
            10年250	10年20
         */

         // rank 1：高 2：中 3：基
        BigDecimal yearSalary = BigDecimal.ZERO;
        int yearNum = 0;

        int oldYearNum = 0;
        Date formalDate = employeeIntoVO.getFormalDate();
        //无司龄调整月份则按0计算
        if (null==formalDate ||null == employeeIntoVO.getYearChangeDate()){
            return yearSalary;
        }
        int year =formalDate.getYear() + 1900;
        int month = formalDate.getMonth() + 1;
        String[] split = monMain.split("-");
        //取上个月司龄
        Period oldPeriod = Period.between(LocalDate.of(year, month, 1), LocalDate.of(Integer.valueOf(split[0]), Integer.valueOf(split[1]), 1));
        if (month == 12){
            year+=1;
            month = 1;
        }else {
            month+=1;
        }
        Period period = Period.between(LocalDate.of(year, month, 1), LocalDate.of(Integer.valueOf(split[0]), Integer.valueOf(split[1]), 1));
        /**
         3、调整工资单司龄计算公式，{司龄=（工资单月份/转正日期（月份+1））}【转正满一年次月计算津贴】
         3.1：当工资单导入月份小于员工入职审批的司龄初始月份，则司龄津贴等于司龄津贴初始值

         3.2：当工资单导入月份等于员工入职审批的司龄初始月份，判断司龄数①1≤司龄≤10，司龄向下取整，司龄津贴=司龄初始值+司龄数对应的金额，②司龄＜1，按0算，③司龄＞10，取初始值
         3.3：当工资单导入月份大于员工入职审批的司龄初始月份，判断司龄数，①1≤司龄≤10，
         司龄向下取整，按人员与上个月份司龄数做对比，是否发生变化，发生变化，用上个月司龄津贴金额+当月司龄数对应的金额，没有发生取上个月司龄金额金额②司龄＜1，按0算，
         **/
         yearNum = period.getYears();
         oldYearNum = oldPeriod.getYears();

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String yearChangeDate = simpleDateFormat.format(employeeIntoVO.getYearChangeDate());
        BigDecimal yearSalaryInit = employeeIntoVO.getYearSalaryInit();
        if (yearChangeDate.compareTo(monMain)>0){
            yearSalary=yearSalaryInit;
        }else if (yearChangeDate.compareTo(monMain)==0){
            /**
             * 当工资单导入月份等于员工入职审批的司龄初始月份，判断司龄数①1≤司龄≤10
             * ，司龄向下取整，司龄津贴=司龄初始值+司龄数对应的金额，②司龄＜1，按0算，③司龄＞10，取初始值
             */
            if (yearNum<1){

            }else if (1<=yearNum &&yearNum<=10) {
                yearSalary = ComputeUtil.safeAdd(yearSalaryInit, yearMap.get(employeeIntoVO.getRank()).get(yearNum));
            }else {
                yearSalary=yearSalaryInit;
            }
        }else if (yearChangeDate.compareTo(monMain)<0){
            //司龄大于10 按10计算
            if (yearNum > 10){
                yearNum =10;
            }
            /**
             * 当工资单导入月份大于员工入职审批的司龄初始月份，
             * 判断司龄数，①1≤司龄≤10，司龄向下取整，按人员与上个月份司龄数做对比，是否发生变化，发生变化，
             * 用上个月司龄津贴金额+当月司龄数对应的金额，没有发生取上个月司龄金额金额②司龄＜1，按0算，
             */
            if (yearNum<1){

            }else if (1<=yearNum &&yearNum<=10) {
                //上个月司龄津贴
                BigDecimal lastSalaryMny = lastDetailMap.get(employeeIntoVO.getIdCard());
                if (null!=lastSalaryMny &&oldYearNum==yearNum){
                    yearSalary=lastSalaryMny;
                }else {
                    yearSalary=ComputeUtil.safeAdd(lastSalaryMny, yearMap.get(employeeIntoVO.getRank()).get(yearNum));
                }
            }

        }
        return yearSalary;
    }

}
