package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.oa.bean.CertSalaryDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成本会计-办事处会员明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_office_member")
public class OfficeMemberEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="name")
    private String name; // 名称
    @TableField(value="handle_person")
    private String handlePerson; // 负责人
    @TableField(value="phone")
    private String phone; // 电话
    @TableField(value="business_manager_id")
    private Long businessManagerId; // 业务经理
    @TableField(value="business_manager_name")
    private String businessManagerName; // 业务经理名称
    @TableField(value="document_person_id")
    private Long documentPersonId; // 资料员
    @TableField(value="document_person_name")
    private String documentPersonName; // 资料员
    @TableField(value="year_mny")
    private BigDecimal yearMny; // 年薪
    @TableField(value="cooperation_term")
    private String cooperationTerm; // 合作期限
    @TableField(value="output_limit")
    private BigDecimal outputLimit; // 产值额度
    @TableField(value="management_fee_point")
    private BigDecimal managementFeePoint; // 管理费收取点数
    @TableField(value="manager_point_rate")
    private BigDecimal managerPointRate; // 业务经理返点比例
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="cooperation_bid_num")
    private String cooperationBidNum; // 合作期间中标数量
    @TableField(value="cooperation_bid_output_mny")
    private BigDecimal cooperationBidOutputMny; // 合作期间中标总产值
    @TableField(value="bid_date")
    private Date bidDate; // 中标日期
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="bid_project_name")
    private String bidProjectName; // 中标项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间

    @TableField(exist=false)
    @SubEntity(serviceName="officeMemberDetailService")
    private List<OfficeMemberDetailEntity> detailList = new ArrayList<>(); //

    public List<OfficeMemberDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OfficeMemberDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getHandlePerson() {
        return handlePerson;
    }

    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Long getBusinessManagerId() {
        return businessManagerId;
    }

    public void setBusinessManagerId(Long businessManagerId) {
        this.businessManagerId = businessManagerId;
    }
    public String getBusinessManagerName() {
        return businessManagerName;
    }

    public void setBusinessManagerName(String businessManagerName) {
        this.businessManagerName = businessManagerName;
    }
    public Long getDocumentPersonId() {
        return documentPersonId;
    }

    public void setDocumentPersonId(Long documentPersonId) {
        this.documentPersonId = documentPersonId;
    }
    public String getDocumentPersonName() {
        return documentPersonName;
    }

    public void setDocumentPersonName(String documentPersonName) {
        this.documentPersonName = documentPersonName;
    }
    public BigDecimal getYearMny() {
        return yearMny;
    }

    public void setYearMny(BigDecimal yearMny) {
        this.yearMny = yearMny;
    }
    public String getCooperationTerm() {
        return cooperationTerm;
    }

    public void setCooperationTerm(String cooperationTerm) {
        this.cooperationTerm = cooperationTerm;
    }
    public BigDecimal getOutputLimit() {
        return outputLimit;
    }

    public void setOutputLimit(BigDecimal outputLimit) {
        this.outputLimit = outputLimit;
    }
    public BigDecimal getManagementFeePoint() {
        return managementFeePoint;
    }

    public void setManagementFeePoint(BigDecimal managementFeePoint) {
        this.managementFeePoint = managementFeePoint;
    }
    public BigDecimal getManagerPointRate() {
        return managerPointRate;
    }

    public void setManagerPointRate(BigDecimal managerPointRate) {
        this.managerPointRate = managerPointRate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCooperationBidNum() {
        return cooperationBidNum;
    }

    public void setCooperationBidNum(String cooperationBidNum) {
        this.cooperationBidNum = cooperationBidNum;
    }
    public BigDecimal getCooperationBidOutputMny() {
        return cooperationBidOutputMny;
    }

    public void setCooperationBidOutputMny(BigDecimal cooperationBidOutputMny) {
        this.cooperationBidOutputMny = cooperationBidOutputMny;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidProjectName() {
        return bidProjectName;
    }

    public void setBidProjectName(String bidProjectName) {
        this.bidProjectName = bidProjectName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
}
