package com.ejianc.business.oa.service.impl;

import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.oa.bean.OilEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.OilUseMapper;
import com.ejianc.business.oa.bean.OilUseEntity;
import com.ejianc.business.oa.service.IOilUseService;

/**
 * 油卡使用明细
 * 
 * @author generator
 * 
 */
@Service("oilUseService")
public class OilUseServiceImpl extends BaseServiceImpl<OilUseMapper, OilUseEntity> implements IOilUseService{
    @Autowired
    private IPushMessageApi pushMessageApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/oil/card?id=";
    @Override
    public String sendMsgToInstallPerson(OilUseEntity entity) {
        logger.info("开始给抄送人发送消息：----");
        //工程名称：-工程名称，预算费用：，请注意
        String msg = this.sendMsg(entity, "抄送人确认", entity.getCcMemo1() + "：请确认！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("开始给标书员、预算员发送消息异常：" + msg);
        }
        logger.info("开始给标书员、预算员发送消息结束！");
        return msg;
    }

    private String sendMsg(OilUseEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getUseCcPeopleId().toString()};
        logger.info("消息接收人: {}", msgRecUserIds);
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
        msgParameter.setPcUrl(PC_URL + entity.getId());

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
