/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectCost"})
public class ProjectCostController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectBillService service;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IProjectRegisterService registerService;

    @RequestMapping(value={"/queryProjectDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectDetailBill(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(100);
        List fuzzyFields = param.getFuzzyFields();
        JSONObject res = new JSONObject();
        if (null == param.getParams().get("projectId")) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
        }
        Long projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
        ProjectRegisterEntity projectRegisterEntity = (ProjectRegisterEntity)((Object)this.registerService.selectById(projectId));
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(Long.valueOf(IdWorker.getId()));
            balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO));
            data.setBalance(balance);
        }
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        res.put("collectionTypeName", (Object)projectRegisterEntity.getCollectionTypeName());
        res.put("contractMny", (Object)projectRegisterEntity.getBidMny());
        res.put("balance", (Object)(null != pageData && pageData.size() > 0 ? pageData.get(pageData.size() - 1).getBalance() : BigDecimal.ZERO));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/projectDetailBillExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void projectDetailBillExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectDetailBillVO> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        BigDecimal balance = BigDecimal.ZERO;
        for (ProjectDetailBillVO data : pageData) {
            data.setId(Long.valueOf(IdWorker.getId()));
            balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO));
            data.setBalance(balance);
        }
        HashMap<String, List<ProjectDetailBillVO>> beans = new HashMap<String, List<ProjectDetailBillVO>>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("ProjectDetailBillReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryCostDetailReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCostDetailReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName", "invoiceCode"));
        JSONObject res = new JSONObject();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = this.service.queryCostDetailReport((Page<InvoiceReceivePoolVO>)page, (QueryWrapper<InvoiceReceivePoolVO>)queryWrapper);
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/costDetailReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void costDetailReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("supplierName", "invoiceCode"));
        JSONObject res = new JSONObject();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InvoiceReceivePoolVO> pageData = this.service.queryCostDetailReport((Page<InvoiceReceivePoolVO>)page, (QueryWrapper<InvoiceReceivePoolVO>)queryWrapper);
        for (InvoiceReceivePoolVO pageDatum : pageData) {
            pageDatum.setPassFlagName(null != pageDatum.getPassFlag() && pageDatum.getPassFlag() == 1 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
        }
        HashMap<String, List<InvoiceReceivePoolVO>> beans = new HashMap<String, List<InvoiceReceivePoolVO>>();
        beans.put("records", pageData);
        ExcelExport.getInstance().export("CostDetailReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryProjectLeaveMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectLeaveMny(Long projectId, Long payContractId, Long paySporadicId) {
        List paySporadicEntityList;
        List list;
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(100);
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        JSONObject res = new JSONObject();
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryWrapper);
        pageData = pageData.stream().filter(e -> null != e.getFeeType() && 0 == e.getFeeType()).collect(Collectors.toList());
        BigDecimal balance = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(pageData) && pageData.size() > 0) {
            for (ProjectDetailBillVO projectDetailBillVO : pageData) {
                balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != projectDetailBillVO.getReceiveMny() ? projectDetailBillVO.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != projectDetailBillVO.getPaymentMny() ? projectDetailBillVO.getPaymentMny() : BigDecimal.ZERO));
            }
        }
        QueryWrapper payContractEntityQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId);
        if (null != payContractId) {
            payContractEntityQueryWrapper.ne((Object)"id", (Object)payContractId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.payContractService.list((Wrapper)payContractEntityQueryWrapper))) && list.size() > 0) {
            balance = ComputeUtil.safeSub((BigDecimal)balance, (BigDecimal)list.stream().filter(item -> null != item.getApplyMny()).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        QueryWrapper paySporadicEntityQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId);
        if (null != paySporadicId) {
            paySporadicEntityQueryWrapper.ne((Object)"id", (Object)paySporadicId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(paySporadicEntityList = this.paySporadicService.list((Wrapper)paySporadicEntityQueryWrapper))) && paySporadicEntityList.size() > 0) {
            balance = ComputeUtil.safeSub((BigDecimal)balance, (BigDecimal)paySporadicEntityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        res.put("projectId", (Object)projectId);
        res.put("balance", (Object)balance);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

