package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayFlowVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 出纳资金-合同付款申请
 * 
 * @author generator
 * 
 */
@Service("payContractService")
public class PayContractServiceImpl extends BaseServiceImpl<PayContractMapper, PayContractEntity> implements IPayContractService{

    @Override
    public List<PayContractVO> pageList(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.pageList(pages, queryWrapper);
    }

    @Override
    public PayFlowVO getFlow(String date) {
        List<PayFlowVO> payFlowVOList = baseMapper.getFlow(date);
        PayFlowVO payFlowVO = new PayFlowVO();
        if (CollectionUtils.isNotEmpty(payFlowVOList)){
            BigDecimal inMny = payFlowVOList.stream().filter(s->s.getInMny() != null).map(PayFlowVO::getInMny)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outMny = payFlowVOList.stream().filter(s->s.getOutMny() != null).map(PayFlowVO::getOutMny)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            payFlowVO.setInMny(inMny);
            payFlowVO.setOutMny(outMny);
        }
        return payFlowVO;
    }
}
