package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.mapper.MonthFeeCommissionMapper;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.vo.BidOpenResultVO;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/11/11 20:41
 */
@Service(value = "monthFeeCommissionService")
public class MonthFeeCommissionServiceImpl extends BaseServiceImpl<MonthFeeCommissionMapper, MonthFeeCommissionEntity> implements IMonthFeeCommissionService {


    @Autowired
    private IMonthFeeCommissionService service;

    @Autowired
    private IBusOpportunityService opportunityService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITenderFileService tenderFileService;
    @Autowired
    private ISupplementBidDocService supplementBidDocService;

    @Autowired
    private IBidOpenResultService bidOpenResultService;

    @Autowired
    private IBidPersonAffirmService bidPersonAffirmService;

    private final String northeastRegion = "东北大区";
    private final Long DBDQOrgId = 1940668587215687681l;
    private final String 北方一建 = "北方一建建设集团公司";
    private final Integer ORG_TYPE_PROJECT_MANAGER_ORG = 3;

    @Override
    public void generateMothFeeCommission() {
        logger.info("---------------自动生成月度 费用提成 报表任务开始---------------");

        //0、查询当前月份是否已生成费用提成报表单
        QueryWrapper<MonthFeeCommissionEntity> query = new QueryWrapper<>();
        query.eq("year", DateUtil.format(new Date(), "yyyy"));
        query.eq("month", DateUtil.format(new Date(), "MM"));
        List<MonthFeeCommissionEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            logger.info("---------------------当前月份已生成费用提成报表，二次生成开始---------------------");
            //每月生成2次  如本月已生成删除本月数据重新生成
            List ids=new ArrayList();
            HashSet updOpprSetIds = new HashSet();
            for (MonthFeeCommissionEntity monthFeeCommissionEntity : list) {
                ids.add(monthFeeCommissionEntity.getId());
                if (null!=monthFeeCommissionEntity.getOpprIds()){
                    updOpprSetIds.addAll(Arrays.asList(StringUtils.split(monthFeeCommissionEntity.getOpprIds(), ",")));
                }
            }
            service.removeByIds(ids,false);
            opportunityService.updateQuoteFlag(new ArrayList(updOpprSetIds), "0");
            logger.info("---------------------更新---------------------");
        }

        List<Long> updateOpprIds = new ArrayList<>();

        //1、查询当前为止生效的商机登记单据
        List<BusOpportunityVO> busOpportunityEntityList = opportunityService.getAllUnQuoteBill();

        if(CollectionUtils.isEmpty(busOpportunityEntityList)) {
            logger.info("---------------------当前未查询到已生效且未被生成费用提成报表的商机登记单据，任务执行结束---------------------");
            return;
        }
        Set<Long> emplyeeIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();

        for(BusOpportunityVO bp : busOpportunityEntityList) {
            if(null != bp.getFollowPersonId()) {
                emplyeeIds.add(bp.getFollowPersonId()); //业务经理
            }
            if(null != bp.getDocumenterId()) {
                emplyeeIds.add(bp.getDocumenterId()); //资料员
            }
            if(null != bp.getNetAuthPersonId()) {
                emplyeeIds.add(bp.getNetAuthPersonId()); //网开授权人
            }
            if(null != bp.getSiteAuthPersonId()) { //现场授权人
                emplyeeIds.add(bp.getSiteAuthPersonId());
            }

            orgIds.add(bp.getOrgId()); //登记单所属组织
        }



        //2、查询资料员、授权人、标书员、业务经理、授权人、外包预算员(成都)、外包预算员(长春) 人员信息
        Map<Long, EmployeeVO> empIdMap = new HashMap<>();
        Map<Long, OrgVO> orgIdMap = new HashMap<>();
        Map<Long, MonthFeeCommissionEntity> monthFeeMap = new HashMap<>();
        List<MonthFeeCommissionEntity> monthFeeList = new ArrayList<>();
        Map<Long, MonthFeeCommissionEntity> saveMap = new HashMap<>();

        if(CollectionUtils.isNotEmpty(emplyeeIds)) {
            logger.info("查到人员，emplyeeIds:{}" + JSONObject.toJSONString(emplyeeIds));
            CommonResponse<List<EmployeeVO>> empList = employeeApi.getJustByIds(new ArrayList<>(emplyeeIds));
            if(!empList.isSuccess()) {
                logger.error("根据人员id列表{}查询人员信息失败", JSONObject.toJSONString(emplyeeIds), JSONObject.toJSONString(empList));
                return;
            }
            logger.info("查到人员，empList:{}",JSONObject.toJSONString(empList));
            logger.info(JSONObject.toJSONString(empList));
            if(CollectionUtils.isNotEmpty(empList.getData())) {
                for(EmployeeVO employee : empList.getData()) {
                    empIdMap.put(employee.getId(), employee);
                    orgIds.add(employee.getOrgId());
                }
            }
        }

        //3、查询资料员所属组织、商机登记所属组织 授权人所属组织、标书员所属组织
        if(CollectionUtils.isNotEmpty(orgIds)) {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findAllByIds(new ArrayList<>(orgIds));
            if(!orgResp.isSuccess()) {
                logger.error("根据组织id列表{}查询人员信息失败", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp));
                return;
            }
            orgIdMap.putAll(orgResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }

        //4、遍历商机单据 统计每个人员的费用项，生成费用提成明细
        EmployeeVO tmpEmp = null;
        MonthFeeCommissionEntity tmpFee = null;
        //东三省、内蒙、山东、北京，商务低于1000元无提成；其他省份低于2000元无提成
        List<Long> areaList = Arrays.asList(1448851723325034588l,1448851723325034518l,1448851498992730150l,1448851498984341553l,1448851879822905473l,1448851498803986433l);
        for(BusOpportunityVO bp : busOpportunityEntityList) {
            //设置组织信息
            if(orgIdMap.containsKey(bp.getOrgId())) {
                bp.setOrgType(orgIdMap.get(bp.getOrgId()).getOrgType());
            }

            if(null != bp.getFollowPersonId() && empIdMap.containsKey(bp.getFollowPersonId())) {
                tmpEmp = empIdMap.get(bp.getFollowPersonId());
            }

            /***
             * 业务经理
             * 1、审批通过的商机登记中资质费用*25%-授权提成，按照人员姓名汇总
             * 2、提成人员为商机登记中业务经理
             */
            if(null != tmpEmp) {
                tmpFee = monthFeeMap.get(tmpEmp.getId());
                if(null == tmpFee) {
                    tmpFee = generateNewFee(tmpEmp, orgIdMap);
                    monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                }
                //东三省、内蒙、山东、北京，商务低于1000元无提成；其他省份低于2000元无提成
                //累计报名提成
                if (!areaList.contains(bp.getProvinceId()) &&ComputeUtil.isGreaterThan(new BigDecimal(2000),bp.getQualificationFee())){
                } else if (areaList.contains(bp.getProvinceId()) && ComputeUtil.isGreaterThan(new BigDecimal(1000),bp.getQualificationFee())){
                }else {
                    tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getRegistrationMny()));
                    tmpFee.setRegistrationMny(ComputeUtil.safeAdd(tmpFee.getRegistrationMny(), ComputeUtil.safeMultiply(bp.getQualificationFee(), new BigDecimal("0.25"))));
                    tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getRegistrationMny(), tmpFee.getTotalMny()));
                }
                monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                saveMap.put(tmpFee.getEmployeeId(), tmpFee);
            } else {
                logger.error("商机登记单id-{} 业务经理id-{}查询为空，跳过处理~", bp.getId(), bp.getFollowPersonId());
            }


            /**
             * 资料员
             * 1、商机登记中的资料员且人员直属组织是东北大区
             * 2、商机登记所属上级不为办事处（即组织类型不为项目经理部）且有对应生效的资料上传单据。
             * 3、计算方式：符合要求的商机数量*40，按人员姓名汇总
             *
             */
            logger.error("资料员1商机登记单id-{}资料员id-{}",  bp.getId(),bp.getDocumenterId());
            if(null != bp.getDocumenterId() && empIdMap.containsKey(bp.getDocumenterId())) {
                tmpEmp = empIdMap.get(bp.getDocumenterId());
                logger.error("资料员2商机登记单id-{}资料员id-{}",  bp.getId(),bp.getDocumenterId());
                if(northeastRegion.equals(bp.getDocumenterOrgName())) {
                    logger.error("资料员3商机登记单id-{}资料员id-{}",  bp.getId(),bp.getDocumenterId());
                    if(orgIdMap.containsKey(bp.getOrgId()) && !ORG_TYPE_PROJECT_MANAGER_ORG.equals(orgIdMap.get(bp.getOrgId()).getOrgType())) {
                        //商机登记商机组织
                        //查询是否有生效的资料上传单据
                        List<TenderFileEntity> fileList = tenderFileService.getByBusOpportunityId(bp.getId());
                        logger.error("资料员4商机登记单id-{}资料员id-{}fileList-{}fileListSize-{}",  bp.getId(),bp.getDocumenterId(), fileList, fileList.size());
                        if(CollectionUtils.isNotEmpty(fileList)) {
                            logger.error("商机登记单id-{}资料员id-{} fileList-{}资料上传11111~",  bp.getId(),bp.getDocumenterId(), fileList);
                            tmpFee = monthFeeMap.get(tmpEmp.getId());
                            if(null == tmpFee) {
                                tmpFee = generateNewFee(tmpEmp, orgIdMap);
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getFileMny()));
                            tmpFee.setFileMny(ComputeUtil.safeAdd(tmpFee.getFileMny(), ComputeUtil.safeMultiply(ComputeUtil.toBigDecimal(fileList.size()),new BigDecimal("40"))));
                            tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getFileMny(), tmpFee.getTotalMny()));
                            monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                            saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                        } else {
                            logger.error("商机登记单id-{} 没有生效的资料上传单据，跳过处理~", bp.getId(), bp.getOrgId());
                        }
                    } else {
                        logger.error("商机登记单id-{} 所属组织id-{}类型为办事处，跳过处理~", bp.getId(), bp.getOrgId());
                    }
                } else {
                    logger.error("商机登记单id-{} 资料员id-{}直属组织不是东北大区，跳过处理~", bp.getId(), bp.getDocumenterId());
                }
            } else {
                logger.error("商机登记单id-{} 资料员id-{}查询为空，跳过处理~", bp.getId(), bp.getDocumenterId());
            }

            /***
             * 网络授权提成
             * 1、商机登记有对应生效的开标结果；
             * 2、依据开标结果中的开标类型是【网开/现场】确认提成人员是授权人（网开）/授权人（现场），且人员直属组织是东北大区。
             * 3、计算方式：网开数量*30；现场数量*100，
             */
            tmpEmp = null;
            List<BidOpenResultEntity> openResultList = bidOpenResultService.getByBusOpportunityId(bp.getId());
            if(CollectionUtils.isNotEmpty(openResultList)) {
                BidOpenResultEntity result = openResultList.get(0);
                if(BidOpenResultVO.OPEN_TYPE_NET.equals(result.getBidOpenType())) {
                    //网开
                    if(null != bp.getNetAuthPersonId()) {
                        tmpEmp = empIdMap.get(bp.getNetAuthPersonId());
                    }
                } else {
                    //现场
                    if(null != bp.getSiteAuthPersonId()) {
                        tmpEmp = empIdMap.get(bp.getNetAuthPersonId());
                    }
                }
                if(null == tmpEmp) {
                    logger.error("商机登记单id-{} 授权人id-{}，授权人类型：{}, 查询为空，跳过处理~", bp.getId(), bp.getDocumenterId(), result.getBidOpenType());
                } else {
                    tmpFee = monthFeeMap.get(tmpEmp.getId());
                    if(null == tmpFee) {
                        tmpFee = generateNewFee(tmpEmp, orgIdMap);
                    }
                    if(BidOpenResultVO.OPEN_TYPE_NET.equals(result.getBidOpenType()) && northeastRegion.equals(bp.getNetAuthPersonOrgName())) {
                        tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getAuthMny()));
                        tmpFee.setAuthMny(ComputeUtil.safeAdd(tmpFee.getAuthMny(),
                                new BigDecimal( "30")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getAuthMny(), tmpFee.getTotalMny()));
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    } else if (BidOpenResultVO.OPEN_TYPE_SITE.equals(result.getBidOpenType()) && northeastRegion.equals(bp.getSiteAuthPersonOrgName())){
                        tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getAuthMny()));
                        tmpFee.setAuthMny(ComputeUtil.safeAdd(tmpFee.getAuthMny(),
                                new BigDecimal( "100")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getAuthMny(), tmpFee.getTotalMny()));
                        monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    }else {
                        logger.error("商机登记单id-{} 授权人id-{}，授权人类型：{}, 直属组织非东北大区，跳过处理~", bp.getId(), bp.getDocumenterId(), result.getBidOpenType());
                    }
                }
            } else {
                logger.error("商机登记单id-{} 不存在生效的开包记录，跳过处理~", bp.getId(), bp.getDocumenterId());
            }

            /***
             * 预算提成
             *
             * 1、人员固定名称为【预算员（成都）、预算员（长春）】
             * 2、商机登记中有生效的确认标书员单据，其中预算员为以上两人
             * 3、计算方式：商机数量*200，按人员汇总
             *
             * 标书提成
             * 1、商机登记有对应生效的确认标书员单据，单据中对应的标书员
             * 2、商机登记有对应生效的上传标书
             * 3、计算方式：
             * 标书员直属组织是北方一建则商机数量*150
             * 标书员直属组织是东北大区则商机数量*200
             */
            List<BidPersonAffirmEntity> bidPersonAffirmList = bidPersonAffirmService.getByBusOpportunityId(bp.getId());
            if(CollectionUtils.isNotEmpty(bidPersonAffirmList)) {
                BidPersonAffirmEntity bidPerson = bidPersonAffirmList.get(0);
                //预算提成
                if("外包预算员（成都）".equals(bidPerson.getBudgetPersonName()) || "外包预算员（长春）".equals(bidPerson.getBudgetPersonName())) {
                    tmpEmp = empIdMap.get(bidPerson.getBudgetPersonId());
                    if(null == tmpEmp) {
                        CommonResponse<EmployeeVO> empResp =employeeApi.getById(bidPerson.getBudgetPersonId());
                        if(empResp.isSuccess()) {
                            logger.info("商机登记单id-{} 询到 预算员人员id-{}信息失败，跳过处理~", bp.getId(), bidPerson.getBudgetPersonId());
                        }
                        tmpEmp = empResp.getData();
                        empIdMap.put(bidPerson.getBudgetPersonId(), tmpEmp);
                    }
                    if(null != tmpEmp) {
                        tmpFee = monthFeeMap.get(tmpEmp.getId());
                        if(null == tmpFee) {
                            tmpFee = generateNewFee(tmpEmp, orgIdMap);
                        }
                        tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getBudgetMny()));
                        tmpFee.setBudgetMny(ComputeUtil.safeAdd(tmpFee.getBudgetMny(), new BigDecimal("200")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getBudgetMny(), tmpFee.getTotalMny()));
                        monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    } else {
                        logger.info("商机登记单id-{} 未查询到 固定人员[预算员（成都）、预算员（长春）]信息，跳过处理~");
                    }
                } else {
                    logger.error("商机登记单id-{} 标书确认单据中预算员非指定的 固定人员[预算员（成都）、预算员（长春）]，跳过处理~", bp.getId(), bp.getDocumenterId());
                }

                //标书提成
                if(null != bidPerson.getBidPersonId()) {
                    tmpEmp = empIdMap.get(bidPerson.getBidPersonId());
                    if(null == tmpEmp) {
                        CommonResponse<EmployeeVO> empResp =employeeApi.getById(bidPerson.getBidPersonId());
                        if(empResp.isSuccess()) {
                            logger.info("商机登记单id-{} 询到 标书人员id-{}信息失败，跳过处理~", bp.getId(), bidPerson.getBidPersonId());
                        }
                        tmpEmp = empResp.getData();
                        empIdMap.put(bidPerson.getBidPersonId(), tmpEmp);
                    }
                    if(null != tmpEmp) {
                        //查询是否有对应生效的上传标书
                        List<SupplementBidDocEntity> docList = supplementBidDocService.getByBusOpportunityId(bp.getId());
                        if(CollectionUtils.isNotEmpty(docList)) {
                            tmpFee = monthFeeMap.get(tmpEmp.getId());
                            if(null == tmpFee) {
                                tmpFee = generateNewFee(tmpEmp, orgIdMap);
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeSub(tmpFee.getTotalMny(),tmpFee.getBidDocMny()));
                            if(northeastRegion.equals(bidPerson.getBidPersonOrgName())) {
                                tmpFee.setBidDocMny(ComputeUtil.safeAdd(tmpFee.getBidDocMny(), new BigDecimal("150")));
                            }
                            if(北方一建.equals(bidPerson.getBidPersonOrgName())) {
                                tmpFee.setBidDocMny(ComputeUtil.safeAdd(tmpFee.getBidDocMny(), new BigDecimal("200")));
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeAdd(tmpFee.getBidDocMny(), tmpFee.getTotalMny()));
                            monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                            saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                        } else {
                            logger.error("商机登记单id-{} 没有生效的上传标书，跳过处理~", bp.getId(), bp.getOrgId());
                        }
                    } else {
                        logger.info("商机登记单id-{} 未查询到 标书人员id-{}信息，跳过处理~", bp.getId(), bidPerson.getBidPersonId());
                    }
                } else {
                    logger.info("商机登记单id-{} 未查询到 标书人员id-{}信息，跳过处理~", bp.getId(), bidPerson.getBidPersonId());
                }
            } else {
                logger.error("商机登记单id-{} 不存在生效的确认标书员单据，跳过处理~", bp.getId(), bp.getDocumenterId());
            }

            updateOpprIds.add(bp.getId());
        }

        //5、更新对应商机登记 报表引用标识为 已引用
        logger.info("本次更新商机{}条", updateOpprIds.size());
        if(CollectionUtils.isNotEmpty(updateOpprIds)) {
            opportunityService.updateQuoteFlag(updateOpprIds, "1");
        }

        //6、保存费用提成明细
        monthFeeList.addAll(saveMap.values());
        if(CollectionUtils.isNotEmpty(monthFeeList)) {
            monthFeeList.forEach(e -> {e.setTenantId(888888L);e.setOpprIds(StringUtil.join(updateOpprIds, ","));}
            );
            logger.info("本次保存数据", JSONObject.toJSONString(saveMap.values()));
            service.saveOrUpdateBatch(monthFeeList, monthFeeList.size(), false);
        }

        logger.info("---------------自动生成月度 费用提成 报表任务执行结束---------------");
    }

    @Override
    public List<MonthFeeCommissionEntity> getByBusOpportunityId(Long id) {

        //先查询商机登记信息
        BusOpportunityEntity bp = opportunityService.selectById(id);

        //根据业务经理、资料员、网开授权人、现场授权人的人员id
        Set<Long> emplyeeIds = new HashSet<>();

        if(null != bp.getFollowPersonId()) {
            emplyeeIds.add(bp.getFollowPersonId()); //业务经理
        }
        if(null != bp.getDocumenterId()) {
            emplyeeIds.add(bp.getDocumenterId()); //资料员
        }
        if(null != bp.getNetAuthPersonId()) {
            emplyeeIds.add(bp.getNetAuthPersonId()); //网开授权人
        }
        if(null != bp.getSiteAuthPersonId()) { //现场授权人
            emplyeeIds.add(bp.getSiteAuthPersonId());
        }


        QueryWrapper<MonthFeeCommissionEntity> query = new QueryWrapper<>();
        query.in("employee_id", emplyeeIds);
        query.eq("month", String.valueOf(bp.getCreateTime().getMonth()));
        query.eq("year", String.valueOf(bp.getCreateTime().getYear()));
        query.orderByDesc("create_time");
        return super.list(query);
    }

    private MonthFeeCommissionEntity generateNewFee(EmployeeVO tmpEmp, Map<Long, OrgVO> orgIdMap) {
        MonthFeeCommissionEntity tmpFee = new MonthFeeCommissionEntity();
        tmpFee.setEmployeeId(tmpEmp.getId());
        tmpFee.setEmployeeCode(tmpEmp.getCode());
        tmpFee.setEmployeeName(tmpEmp.getName());
        tmpFee.setPostName(tmpEmp.getPostName());
        tmpFee.setDeptName(tmpEmp.getDeptName());
        logger.error("----------------实体{}++++++postname{}deptname{}",JSONObject.toJSONString(tmpEmp),tmpEmp.getPostName(),tmpEmp.getDeptName());
        tmpFee.setOrgId(tmpEmp.getOrgId());
        tmpFee.setYear(DateUtil.format(new Date(), "yyyy"));
        tmpFee.setMonth(DateUtil.format(new Date(), "MM"));
        tmpFee.setBillDate(new Date());
        if(orgIdMap.containsKey(tmpEmp.getOrgId())) {
            tmpFee.setOrgCode(orgIdMap.get(tmpEmp.getOrgId()).getCode());
            tmpFee.setOrgName(orgIdMap.get(tmpEmp.getOrgId()).getName());
            tmpEmp.setOrgName(tmpFee.getOrgName());
        }

        //金额初始化
        tmpFee.setTotalMny(BigDecimal.ZERO);
        tmpFee.setBudgetMny(BigDecimal.ZERO);
        tmpFee.setAuthMny(BigDecimal.ZERO);
        tmpFee.setBidDocMny(BigDecimal.ZERO);
        tmpFee.setRegistrationMny(BigDecimal.ZERO);
        tmpFee.setFileMny(BigDecimal.ZERO);

        return tmpFee;
    }
}
