package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.oa.vo.CertRecordRecordVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.CertRecordDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-证书档案
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_record")
public class CertRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="human_type")
    private Integer humanType; // 人员类别（1内部2外部）
    @TableField(value="human_type_name")
    private String humanTypeName; // 人员类别
    @TableField(value="human_pay_id")
    private Long humanPayId; // 姓名
    @TableField(value="human_pay_name")
    private String humanPayName; // 姓名
    @TableField(value="phone")
    private String phone; // 移动电话
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="major")
    private String major; // 所学专业
    @TableField(value="educated")
    private String educated; // 最高学历
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="certRecordDetailService",pidName = "recordId")
    private List<CertRecordDetailEntity> certRecordDetailList = new ArrayList<>(); // 人力行政-证书档案-证件信息

    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="task_version")
    private Integer taskVersion; // 版本号
    @TableField(value="before_task_version")
    private Integer beforeTaskVersion; // 历史版本号
    @TableField(value="last_task_id")
    private Long lastTaskId; // 上一版本主键
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_task_id")
    private Long baseTaskId; // 原始版本主键


    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_employee_id")
    private Long changeEmployeeId; // 变更经办人
    @TableField(value="change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_effect_date")
    private Date changeEffectDate; // 变更生效时间

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Integer getTaskVersion() {
        return taskVersion;
    }

    public void setTaskVersion(Integer taskVersion) {
        this.taskVersion = taskVersion;
    }

    public Integer getBeforeTaskVersion() {
        return beforeTaskVersion;
    }

    public void setBeforeTaskVersion(Integer beforeTaskVersion) {
        this.beforeTaskVersion = beforeTaskVersion;
    }

    public Long getLastTaskId() {
        return lastTaskId;
    }

    public void setLastTaskId(Long lastTaskId) {
        this.lastTaskId = lastTaskId;
    }

    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }

    public Long getBaseTaskId() {
        return baseTaskId;
    }

    public void setBaseTaskId(Long baseTaskId) {
        this.baseTaskId = baseTaskId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }

    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }

    public Long getHumanPayId() {
        return humanPayId;
    }

    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<CertRecordDetailEntity> getCertRecordDetailList() {
        return certRecordDetailList;
    }

    public void setCertRecordDetailList(List<CertRecordDetailEntity> certRecordDetailList) {
        this.certRecordDetailList = certRecordDetailList;
    }
}
