/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.invest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.bean.ProjectRepaymentEntity;
import com.ejianc.business.invest.service.IProjectDebtService;
import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.business.invest.vo.ProjectRepaymentVO;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectRepayment"})
public class ProjectRepaymentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_XMTZ_XMHK";
    @Autowired
    private IProjectBillService projectBillService;
    @Autowired
    private IProjectRepaymentService service;
    @Autowired
    private IProjectDebtService projectDebtService;
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> saveOrUpdate(@RequestBody ProjectRepaymentVO saveOrUpdateVO) {
        ProjectRepaymentEntity entity = (ProjectRepaymentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectRepaymentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectRepaymentVO vo = (ProjectRepaymentVO)BeanMapper.map((Object)((Object)entity), ProjectRepaymentVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> queryDetail(Long id) {
        ProjectRepaymentEntity entity = (ProjectRepaymentEntity)((Object)this.service.selectById(id));
        ProjectRepaymentVO vo = (ProjectRepaymentVO)BeanMapper.map((Object)((Object)entity), ProjectRepaymentVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectRepaymentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectRepaymentVO projectRepaymentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectRepaymentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("businessManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectRepaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("businessManagerName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, ProjectRepaymentVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("ProjectRepayment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectRepaymentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectRepaymentVO>> refProjectRepaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectRepaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProjectDebt"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectRepaymentVO> queryProjectDebt(Long projectId, Long projectDebtId) {
        ProjectRepaymentVO projectRepaymentVO = this.service.queryProjectDebt(projectId);
        List repaymentEntityList = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_debt_id", (Object)projectDebtId)).notIn((Object)"bill_state", Arrays.asList(1, 3)));
        if (CollectionUtils.isNotEmpty((Collection)repaymentEntityList) && repaymentEntityList.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u501f\u6b3e\u5355\u6709\u672a\u751f\u6548\u7684\u8fd8\u6b3e\u5355\uff01", (Object)new ProjectRepaymentVO());
        }
        List registerEntityList = this.projectRegisterService.list((Wrapper)new QueryWrapper().eq((Object)"follow_person_id", (Object)projectRepaymentVO.getBusinessManagerId()));
        if (CollectionUtils.isNotEmpty((Collection)registerEntityList) && registerEntityList.size() > 0) {
            List projectIds = registerEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List projectDebtEntityList = this.projectDebtService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"project_id", projectIds)).in((Object)"bill_state", Arrays.asList(1, 3)));
            List projectRepaymentEntityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"project_id", projectIds)).in((Object)"bill_state", Arrays.asList(1, 3))).orderByDesc((Object)"handle_date"));
            if (CollectionUtils.isNotEmpty((Collection)projectDebtEntityList) && projectDebtEntityList.size() > 0) {
                for (ProjectDebtEntity projectDebtEntity : projectDebtEntityList) {
                    if (null == projectDebtId || projectDebtId.longValue() != projectDebtEntity.getId().longValue()) continue;
                    projectRepaymentVO.setBillDebtMny(projectDebtEntity.getDebtMny());
                    break;
                }
                BigDecimal managerDebtMny = projectDebtEntityList.stream().filter(p -> p.getDebtMny() != null).map(ProjectDebtEntity::getDebtMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (CollectionUtils.isNotEmpty((Collection)projectRepaymentEntityList) && projectRepaymentEntityList.size() > 0) {
                    BigDecimal projectRepaymentMny = projectRepaymentEntityList.stream().filter(p -> p.getRepaymentCapitalMny() != null).map(ProjectRepaymentEntity::getRepaymentCapitalMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    managerDebtMny = ComputeUtil.safeSub((BigDecimal)managerDebtMny, (BigDecimal)projectRepaymentMny);
                    BigDecimal billLastRepaymentMny = projectRepaymentEntityList.stream().filter(e -> projectDebtId.equals(e.getProjectDebtId()) && e.getRepaymentCapitalMny() != null).map(ProjectRepaymentEntity::getRepaymentCapitalMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectRepaymentVO.setBillLastRepaymentMny(billLastRepaymentMny);
                    projectRepaymentVO.setBillRepaymentMny(billLastRepaymentMny);
                    for (ProjectRepaymentEntity projectRepaymentEntity : projectRepaymentEntityList) {
                        if (null != projectRepaymentVO.getHandleDate() || projectDebtId.longValue() != projectRepaymentEntity.getProjectDebtId().longValue()) continue;
                        projectRepaymentVO.setAllInterestMny(projectRepaymentEntity.getAllInterestMny());
                        projectRepaymentVO.setLastAllInterestMny(projectRepaymentEntity.getAllInterestMny());
                        projectRepaymentVO.setRemainInterestMny(projectRepaymentEntity.getRemainInterestMny());
                        projectRepaymentVO.setLastHandleDate(projectRepaymentEntity.getHandleDate());
                        break;
                    }
                }
                projectRepaymentVO.setBillDebtResidueMny(BigDecimalUtil.safeSub(projectRepaymentVO.getBillDebtMny(), null == projectRepaymentVO.getBillLastRepaymentMny() ? BigDecimal.ZERO : projectRepaymentVO.getBillLastRepaymentMny()));
                projectRepaymentVO.setManagerDebtMny(managerDebtMny);
            }
        }
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76eeid\u67e5\u8be2\u501f\u6b3e\u5355\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01", (Object)projectRepaymentVO);
    }

    @RequestMapping(value={"/queryRepaymentByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryRepaymentByProjectId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        ProjectBillEntity projectBillEntity = (ProjectBillEntity)((Object)this.projectBillService.selectById(projectBillId));
        List list = this.service.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectBillEntity.getProjectId()));
        returnObject.put("detailList", (Object)list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)returnObject);
    }
}

