package com.ejianc.business.bid.service;



import com.ejianc.business.bid.bean.AreaEntity;
import com.ejianc.business.bid.vo.AreaVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/12 10:48
 */
public interface IAreaService extends IBaseService<AreaEntity> {

    /**
     * 根据主键批量物理删除行政地区记录
     *
     * @param collect
     */
    void batchDelByIds(List<Long> collect);

    /**
     * 查询行政地区信息
     *
     * @param pid
     * @return
     */
    List<Map> queryAll(Long pid);

    /**
     * 查询匹配的地区列表
     *
     * @param pid
     * @param billCode
     * @param areaName
     * @param status
     * @return
     */
    List<AreaVO> queryList(Long pid, String billCode, String areaName, Integer status);
}
