/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.ejianc.business.oa.bean.OilUseEntity;
import com.ejianc.business.oa.mapper.OilUseMapper;
import com.ejianc.business.oa.service.IOilUseService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oilUseService")
public class OilUseServiceImpl
extends BaseServiceImpl<OilUseMapper, OilUseEntity>
implements IOilUseService {
    @Autowired
    private IPushMessageApi pushMessageApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/oil/card?id=";

    @Override
    public String sendMsgToInstallPerson(OilUseEntity entity) {
        this.logger.info("\u5f00\u59cb\u7ed9\u6284\u9001\u4eba\u53d1\u9001\u6d88\u606f\uff1a----");
        String msg = this.sendMsg(entity, "\u6284\u9001\u4eba\u786e\u8ba4", entity.getCcMemo1() + "\uff1a\u8bf7\u786e\u8ba4\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u5f00\u59cb\u7ed9\u6807\u4e66\u5458\u3001\u9884\u7b97\u5458\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u5f00\u59cb\u7ed9\u6807\u4e66\u5458\u3001\u9884\u7b97\u5458\u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff01");
        return msg;
    }

    private String sendMsg(OilUseEntity entity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{entity.getUseCcPeopleId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", msgRecUserIds);
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

