/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.utils.ReformState;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"checkResult"})
public class CheckResultController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckBfyjService service;
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckBfyjVO> queryDetail(@RequestParam Long id) {
        CheckBfyjEntity entity = (CheckBfyjEntity)((Object)this.service.selectById(id));
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails, CheckDetailBfyjVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            CheckDetailBfyjVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        CheckBfyjVO vo = (CheckBfyjVO)BeanMapper.map((Object)((Object)entity), CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map params = param.getParams();
        if (params.containsKey("overdueNum")) {
            String overdueNum = (String)((Parameter)params.get("overdueNum")).getValue();
            params.remove("overdueNum");
            if (overdueNum.equals("1")) {
                param.getParams().put("overdueNum", new Parameter("gt", (Object)0));
            }
            if (overdueNum.equals("0")) {
                param.getParams().put("overdueNum", new Parameter("eq", (Object)0));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckBfyjVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = this.service.queryList(param);
        List sceneCheckVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sceneCheckVOS = BeanMapper.mapList((Iterable)list, CheckBfyjVO.class);
            sceneCheckVOS.forEach(vo -> vo.setReformName(ReformState.getEnumByStateCode(vo.getReformStatus()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("SceneCheckResult-export.xlsx", beans, response);
    }
}

