package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.InstoreDetailEntity;
/**
 * 人力行政-资产入库单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_instore")
public class InstoreEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="instore_date")
    private Date instoreDate; // 入库日期
    @TableField(value="main_source_type")
    private String mainSourceType; // 来源: 0-手动新增， 1-调拨单生成
    @TableField(value="main_source_id")
    private Long mainSourceId; // 数据来源主表id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间

    @TableField(value="dept_id")
    private Long deptId; // 使用部门ID
    @TableField(value="dept_name")
    private String deptName; // 使用部门
    @TableField(value="handle_person_id")
    private Long handlePersonId; // 负责人
    @TableField(value="handle_person_name")
    private String handlePersonName; // 负责人名称
    @TableField(value="place")
    private String place; // 地点
    
    @TableField(exist=false)
    @SubEntity(serviceName="instoreDetailService", pidName = "instoreId")
    private List<InstoreDetailEntity> detailList = new ArrayList<>(); // 人力行政-资产入库单子表


    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getHandlePersonId() {
        return handlePersonId;
    }

    public void setHandlePersonId(Long handlePersonId) {
        this.handlePersonId = handlePersonId;
    }

    public String getHandlePersonName() {
        return handlePersonName;
    }

    public void setHandlePersonName(String handlePersonName) {
        this.handlePersonName = handlePersonName;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    public String getMainSourceType() {
        return mainSourceType;
    }

    public void setMainSourceType(String mainSourceType) {
        this.mainSourceType = mainSourceType;
    }
    public Long getMainSourceId() {
        return mainSourceId;
    }

    public void setMainSourceId(Long mainSourceId) {
        this.mainSourceId = mainSourceId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }


    public List<InstoreDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<InstoreDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
