package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.PayrollDetailEntity;
/**
 * 人力行政-工资表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_payroll")
public class PayrollEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="total_salary_mny")
    private BigDecimal totalSalaryMny; // 应发工资总额
    @TableField(value="total_actual_salary_mny")
    private BigDecimal totalActualSalaryMny; // 实发工资总额
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="payrollDetailService", pidName = "payrollId")
    private List<PayrollDetailEntity> detailList = new ArrayList<>(); // 人力行政-工资表子表
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getTotalSalaryMny() {
        return totalSalaryMny;
    }

    public void setTotalSalaryMny(BigDecimal totalSalaryMny) {
        this.totalSalaryMny = totalSalaryMny;
    }
    public BigDecimal getTotalActualSalaryMny() {
        return totalActualSalaryMny;
    }

    public void setTotalActualSalaryMny(BigDecimal totalActualSalaryMny) {
        this.totalActualSalaryMny = totalActualSalaryMny;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }


    public List<PayrollDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PayrollDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
