package com.ejianc.business.oa.service.impl;

import com.ejianc.business.oa.bean.*;
import com.ejianc.business.oa.service.*;
import com.ejianc.business.oa.vo.CertHumanRecordVO;
import com.ejianc.business.oa.vo.CertHumanVO;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;

@Service("certHumanChange") 
public class CertHumanChangeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ICertHumanChangeService changeService;

	@Autowired
	private ICertHumanService certService;


	@Autowired
	private ICertHumanRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CertHumanChangeEntity changeEntity = changeService.selectById(billId);
		/**复制合同表数据到记录表 begin */
		CertHumanVO certHumanVO = BeanMapper.map(certService.selectById(changeEntity.getApplyId()), CertHumanVO.class);
		CertHumanRecordEntity recordEntity = BeanMapper.map(certHumanVO, CertHumanRecordEntity.class);
		recordEntity.setApplyId(recordEntity.getId());
		recordEntity.setId(null);
		recordService.saveOrUpdate(recordEntity, false);
		/**复制合同表数据到记录表 end */

		/**更新变更表表头数据到合同 begin */
		CertHumanEntity entity = BeanMapper.map(changeEntity, CertHumanEntity.class);
		entity.setId(changeEntity.getApplyId());
		entity.setChangeStatus(3);
		boolean b = certService.updateById(entity);
		/**复制合同表数据到记录表 end */
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
