package com.ejianc.business.oa.service.impl;

import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.oa.bean.InsurancePaymentApplyEntity;
import com.ejianc.business.oa.bean.MonInsuranceEntity;
import com.ejianc.business.oa.service.IInsurancePaymentApplyService;
import com.ejianc.business.oa.service.IMonInsuranceService;
import com.ejianc.business.oa.vo.MonInsuranceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("insurancePaymentApply") 
public class InsurancePaymentApplyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IInsurancePaymentApplyService service;
	@Autowired
	private IMonInsuranceService monInsuranceService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		InsurancePaymentApplyEntity insuranceEntity = service.selectById(billId);
		MonInsuranceVO monInsuranceVO = new MonInsuranceVO();
		monInsuranceVO.setHumanType(null!=insuranceEntity.getHumanType()?insuranceEntity.getHumanType().toString():null);
		monInsuranceVO.setHumanTypeName(insuranceEntity.getHumanTypeName());
		monInsuranceVO.setPersonId(insuranceEntity.getPersonId());
		monInsuranceVO.setPersonName(insuranceEntity.getPersonName());
		monInsuranceVO.setDeptId(insuranceEntity.getDeptId());
		monInsuranceVO.setDeptName(insuranceEntity.getDeptName());
		monInsuranceVO.setInsuredType(insuranceEntity.getInsuredType());
		monInsuranceVO.setInsuredTypeName(insuranceEntity.getInsuredTypeName());
		monInsuranceVO.setFeesBorne(insuranceEntity.getFeesBorne());
		monInsuranceVO.setFeesBorneName(insuranceEntity.getFeesBorneName());
		monInsuranceVO.setCompanyTotalMnyMonth(insuranceEntity.getCompanyTotalMnyMonth());
		monInsuranceVO.setPersonTotalMnyMonth(insuranceEntity.getPersonTotalMnyMonth());
		monInsuranceVO.setTotalMnyMonth(insuranceEntity.getTotalMnyMonth());
		monInsuranceVO.setUpDown("1");
		monInsuranceVO.setBillDate(new Date());
		monInsuranceVO.setYear(DateUtil.format(new Date(), "yyyy"));
		monInsuranceVO.setMonth(DateUtil.format(new Date(), "MM"));
		monInsuranceVO.setTenantId(888888l);
		monInsuranceVO.setInsuranceId(insuranceEntity.getId());
		monInsuranceService.saveOrUpdate(BeanMapper.map(monInsuranceVO, MonInsuranceEntity.class),false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
