/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.mapper.TenderFundsMapper;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.ITenderFundsService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tenderFundsService")
public class TenderFundsServiceImpl
extends BaseServiceImpl<TenderFundsMapper, TenderFundsEntity>
implements ITenderFundsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/tenderFunds/card?id=";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBusOpportunityService busOpportunityService;

    @Override
    public List<TenderFundsEntity> getByBusOpportunityId(Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"opportunity_id", (Object)id);
        query.orderByDesc((Object)"create_time");
        return super.list((Wrapper)query);
    }

    @Override
    public void saveQuoteBillId(Long id, Long quoteBillId) {
        TenderFundsEntity e = (TenderFundsEntity)((Object)super.selectById((Serializable)id));
        e.setFundsBackId(null == quoteBillId ? Long.valueOf("0") : quoteBillId);
        super.saveOrUpdate((Object)e, false);
    }

    @Override
    public void delAllQuoteBillId(List<Long> quoteBillIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"funds_back_id", quoteBillIds);
        update.set((Object)"funds_back_id", (Object)Long.valueOf("0"));
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    public void changeBusinessStatus(List<Long> ids, String status) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"bounds_status", (Object)status);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    public void sendMsgToDocumenter(TenderFundsEntity entity) {
        this.logger.info("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\uff1a----");
        String msg = this.sendMsg(entity, "\u6295\u6807\u4fdd\u8bc1\u91d1\u5df2\u4ed8", entity.getEngineeringName() + "\uff0c\u6295\u6807\u4fdd\u8bc1\u91d1\u5df2\u4ed8\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u5f00\u59cb\u7ed9\u8d44\u6599\u5458\u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff01");
    }

    private String sendMsg(TenderFundsEntity entity, String subject, String content) {
        BusOpportunityEntity oppr = (BusOpportunityEntity)((Object)this.busOpportunityService.selectById(entity.getOpportunityId()));
        Object[] msgRecUserIds = new String[]{oppr.getDocumenterId().toString(), entity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

