/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paySporadic")
public class PaySporadicBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPaySporadicService service;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        List registerList = this.invoiceReceiveRegistService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)entity.getProjectId())).eq((Object)"seller_id", (Object)entity.getSupplyId()));
        if (CollectionUtils.isNotEmpty((Collection)registerList) && registerList.size() > 0) {
            List<InvoiceReceivePoolEntity> registerPoolList;
            InvoiceReceiveRegistEntity registerEntity = (InvoiceReceiveRegistEntity)((Object)registerList.get(0));
            List entityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)entity.getProjectId())).eq((Object)"supply_id", (Object)entity.getSupplyId())).in((Object)"bill_state", Arrays.asList(1, 3))).ne((Object)"id", (Object)entity.getId()));
            BigDecimal applyMny = entity.getApplyMny();
            if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 1) {
                applyMny = ComputeUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)entityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (applyMny.compareTo(registerEntity.getContractMnyTax()) == 0 && applyMny.compareTo(registerEntity.getTotalReceiveMnyTax()) == 0 && CollectionUtils.isNotEmpty(registerPoolList = (registerEntity = (InvoiceReceiveRegistEntity)((Object)this.invoiceReceiveRegistService.selectById(registerEntity.getId()))).getInvoiceReceivePoolList()) && registerPoolList.size() > 0) {
                registerPoolList.forEach(e -> e.setPassFlag(1));
            }
            registerEntity.setSumPayMny(applyMny);
            this.invoiceReceiveRegistService.saveOrUpdate((Object)registerEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceReceiveRegistEntity registerEntity;
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u652f\u4ed8\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        List registerList = this.invoiceReceiveRegistService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)entity.getProjectId())).eq((Object)"seller_id", (Object)entity.getSupplyId()));
        if (CollectionUtils.isNotEmpty((Collection)registerList) && registerList.size() > 0 && null != (registerEntity = (InvoiceReceiveRegistEntity)((Object)registerList.get(0))).getProjectBillId()) {
            return CommonResponse.error((String)"\u7533\u8bf7\u5355\u4e0b\u6e38\u6536\u7968\u5df2\u88ab\u5bf9\u8d26\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceReceiveRegistEntity registerEntity;
        PaySporadicEntity applyEntity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        applyEntity.setPayMny(BigDecimal.ZERO);
        applyEntity.setUnPayMny(ComputeUtil.safeSub((BigDecimal)applyEntity.getApplyMny(), (BigDecimal)applyEntity.getPayMny()));
        applyEntity.setConfirmTime(null);
        this.service.updateById((Object)applyEntity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        List registerList = this.invoiceReceiveRegistService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)applyEntity.getProjectId())).eq((Object)"seller_id", (Object)applyEntity.getSupplyId()));
        if (CollectionUtils.isNotEmpty((Collection)registerList) && registerList.size() > 0 && null == (registerEntity = (InvoiceReceiveRegistEntity)((Object)registerList.get(0))).getProjectBillId()) {
            List<InvoiceReceivePoolEntity> registerPoolList;
            List entityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)applyEntity.getProjectId())).eq((Object)"supply_id", (Object)applyEntity.getSupplyId())).in((Object)"bill_state", Arrays.asList(1, 3))).ne((Object)"id", (Object)applyEntity.getId()));
            BigDecimal applyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 1) {
                applyMny = entityList.stream().filter(item -> null != item.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((applyMny.compareTo(registerEntity.getContractMnyTax()) != 0 || applyMny.compareTo(registerEntity.getTotalReceiveMnyTax()) != 0) && CollectionUtils.isNotEmpty(registerPoolList = (registerEntity = (InvoiceReceiveRegistEntity)((Object)this.invoiceReceiveRegistService.selectById(registerEntity.getId()))).getInvoiceReceivePoolList()) && registerPoolList.size() > 0) {
                registerPoolList.forEach(e -> e.setPassFlag(0));
            }
            registerEntity.setSumPayMny(applyMny);
            this.invoiceReceiveRegistService.saveOrUpdate((Object)registerEntity, false);
        }
        return CommonResponse.success();
    }
}

