package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.CertPayEntity;
import com.ejianc.business.oa.service.ICertPayService;
import com.ejianc.business.oa.vo.CertPayVO;

/**
 * 人力行政-证书人员付款申请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("certPay")
public class CertPayController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/certPay/card?id=";
    private static final String BILL_CODE = "BFYJ_OA-ZSRYFKSQ";//此处需要根据实际修改
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ICertPayService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertPayVO> saveOrUpdate(@RequestBody CertPayVO saveOrUpdateVO) {
    	CertPayEntity entity = BeanMapper.map(saveOrUpdateVO, CertPayEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (null==entity.getState()){
            entity.setState(1);
        }
    	service.saveOrUpdate(entity, false);
    	CertPayVO vo = BeanMapper.map(entity, CertPayVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertPayVO> queryDetail(Long id) {
    	CertPayEntity entity = service.selectById(id);
    	CertPayVO vo = BeanMapper.map(entity, CertPayVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertPayVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CertPayVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CertPayVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CertPayVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","certHumanName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<CertPayEntity> page = service.queryPage(param,false);
        IPage<CertPayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertPayVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @PostMapping(value = "certWarnExecute")
    public CommonResponse<String> certWarnExecute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("查询证书人员付款申请预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行设备租赁合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("查询证书人员付款申请预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("查询证书人员付款申请预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = service.queryCertWarnExecute(sqlParamList);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("查询证书人员付款申请预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("查询证书人员付款申请预警完成的数据：{}", JSONObject.toJSONString(result));
        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }
    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }
    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != m.get("certName") ? m.get("certName").toString() + " - " : "")  + m.get("certCode").toString());
            vo.setPcTitle("证书人员付款申请");
            vo.setPcUrl(PC_URL + m.get("certId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("certId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            if (Integer.parseInt(m.get("day").toString()) >= 0) {
                tmpContent = "【" + m.get("certName").toString() + "】的证书到期时间为【" + m.get("endDate").toString() + "】,距离结束时间还有"
                        + m.get("day").toString() + "天!";
            }
            if (Integer.parseInt(m.get("day").toString()) < 0){
                Integer day = -Integer.parseInt(m.get("day").toString());
                tmpContent = "【" + m.get("certName").toString() + "】的证书到期时间为【"+ m.get("endDate").toString()+"】,已经到期"
                        +day + "天!";
            }
            vo.setEarlywarnContent(tmpContent);
            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","certHumanName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CertPayEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<CertPayVO> voList = BeanMapper.mapList(list, CertPayVO.class);
        for (CertPayVO certPayVO : voList) {
            certPayVO.setStateName(1==certPayVO.getState()?"在职":"离职");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("CertPay-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCertPayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CertPayVO>> refCertPayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("deptName");
        param.getFuzzyFields().add("certHumanName");
        param.getFuzzyFields().add("certName");
        param.getFuzzyFields().add("compatibility");
        param.getFuzzyFields().add("postName");
        param.getFuzzyFields().add("payTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CertPayEntity> page = service.queryPage(param,false);
        IPage<CertPayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertPayVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
