package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.OccupyMapper;
import com.ejianc.business.finance.service.IOccupyService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 出纳资金-占用资金表-主表
 * 
 * @author generator
 * 
 */
@Service("occupyService")
public class OccupyServiceImpl extends BaseServiceImpl<OccupyMapper, OccupyEntity> implements IOccupyService{
    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IProjectBillService projectBillService;
    @Override
    public OccupyVO queryData() {
        OccupyEntity occupyEntity = new OccupyEntity();
        occupyEntity.setId(IdWorker.getId());
        QueryParam param = new QueryParam();
        QueryWrapper<ProjectDetailBillVO> queryWrapper = changeToQueryWrapper(param);
        Page<ProjectDetailBillVO> page = new Page<>(1, -1);
        List<ProjectDetailBillVO> detailList = projectBillService.pageList(page, queryWrapper);
        List<OccupyDetailEntity> occupyDetailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)) {
            // 分组后汇总
            // 查询工程计量台账往期值
            Map<Long,BigDecimal> receiveMap = detailList.stream().filter(item -> null != item.getReceiveMny()&&null!=item.getProjectId()).collect(
                    Collectors.groupingBy(s -> s.getProjectId(),
                            Collectors.mapping(ProjectDetailBillVO::getReceiveMny, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long,BigDecimal> paymentMap = detailList.stream().filter(item -> null != item.getPaymentMny()&&null!=item.getProjectId()).collect(
                    Collectors.groupingBy(s -> s.getProjectId(),
                            Collectors.mapping(ProjectDetailBillVO::getPaymentMny, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long,ProjectDetailBillVO> detailMap =detailList.stream().filter(item -> null != item.getProjectId()&&null!=item.getProjectId()).collect(Collectors.toMap(
                    ProjectDetailBillVO::getProjectId,
                    item -> item,
                    (existing, replacement) -> existing
            ));
            List<ProjectDetailBillVO> detail = new ArrayList<>(detailMap.values());
            detailMap.forEach((projectId, projectDetailBillVO) -> {
                OccupyDetailEntity occupyDetailEntity = new OccupyDetailEntity();
                occupyDetailEntity.setProjectId(projectId);
                occupyDetailEntity.setProjectName(projectDetailBillVO.getProjectName());
//                occupyDetailEntity.setOrgId(receiveEntity.getOrgId());
//                occupyDetailEntity.setOrgName(receiveEntity.getOrgName());
                BigDecimal money = ComputeUtil.safeSub(receiveMap.get(projectId), paymentMap.get(projectId));
                occupyDetailEntity.setMoney(money);
                occupyDetailEntity.setId(IdWorker.getId());
                occupyDetailEntity.setMid(occupyEntity.getId());
                occupyDetailEntityList.add(occupyDetailEntity);
            });

            BigDecimal money = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOccupyMny(money);

            //查询往期值
            LambdaQueryWrapper<OccupyEntity> lambdaLastWrapper = new LambdaQueryWrapper<>();
            lambdaLastWrapper.in(OccupyEntity::getBillState, 1, 3);
            lambdaLastWrapper.orderByDesc(OccupyEntity::getDate);
            List<OccupyEntity> daypayEntityList = super.list(lambdaLastWrapper);
            BigDecimal occupyLastMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(daypayEntityList)) {
                OccupyEntity occupyLastEntity = daypayEntityList.stream().findFirst().get();
                occupyLastMny = occupyLastEntity.getOccupyMny();
                //查询往期值
            }
            if (money.compareTo(ComputeUtil.nullToZero(occupyLastMny)) > -1) {
                occupyEntity.setUpMny(ComputeUtil.safeSub(money, occupyLastMny));
            } else {
                occupyEntity.setDownMny(ComputeUtil.safeSub(occupyLastMny, money));
            }

            occupyEntity.setOccupyDetailList(occupyDetailEntityList);
        }
        OccupyVO occupyVO = BeanMapper.map(occupyEntity, OccupyVO.class);
        return occupyVO;
    }


}
