/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.TenderFileEntity;
import com.ejianc.business.bid.mapper.TenderFileMapper;
import com.ejianc.business.bid.service.ITenderFileService;
import com.ejianc.business.bid.vo.TenderFileVO;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="tenderFileService")
public class TenderFileServiceImpl
extends BaseServiceImpl<TenderFileMapper, TenderFileEntity>
implements ITenderFileService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID-TENDER-FILE";
    @Autowired
    private ITenderFileService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public List<TenderFileEntity> getByBusOpportunityId(Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"opportunity_id", (Object)id);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.orderByDesc((Object)"create_time");
        return super.list((Wrapper)query);
    }

    @Override
    public TenderFileVO saveOrUpdate(TenderFileVO saveOrUpdateVO) {
        TenderFileEntity entity = (TenderFileEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TenderFileEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        TenderFileVO vo = (TenderFileVO)BeanMapper.map((Object)((Object)entity), TenderFileVO.class);
        String pusherId = vo.getPusherId();
        ArrayList<String> pusherIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)pusherId)) {
            String[] split = pusherId.split(",");
            pusherIds = Arrays.asList(split);
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        String formurl = this.baseHost + "ejc-bfyjerp-frontend/#/tenderFile";
        if (CollectionUtils.isNotEmpty(pusherIds)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(vo.getEngineeringName() + "\u9879\u76ee,\u8d44\u6599\u4e0a\u4f20\u5df2\u505a\u8c03\u6574\uff0c\u8bf7\u67e5\u770b");
            String subject = buffer.toString();
            String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, pusherIds, "notice", subject, content, null);
        }
        return vo;
    }
}

