package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.WinningRegistrationEntity;
import com.ejianc.business.bid.mapper.WinningRegistrationMapper;
import com.ejianc.business.bid.service.IWinningRegistrationService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 投标管理-中标登记
 * 
 * @author generator
 * 
 */
@Service("winningRegistrationService")
public class WinningRegistrationServiceImpl extends BaseServiceImpl<WinningRegistrationMapper, WinningRegistrationEntity> implements IWinningRegistrationService{

    @Override
    public List<WinningRegistrationEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<WinningRegistrationEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
