/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.MonthFeeCommissionEntity;
import com.ejianc.business.bid.bean.SupplementBidDocEntity;
import com.ejianc.business.bid.bean.TenderFileEntity;
import com.ejianc.business.bid.mapper.MonthFeeCommissionMapper;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IBidPersonAffirmService;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.IMonthFeeCommissionService;
import com.ejianc.business.bid.service.ISupplementBidDocService;
import com.ejianc.business.bid.service.ITenderFileService;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthFeeCommissionService")
public class MonthFeeCommissionServiceImpl
extends BaseServiceImpl<MonthFeeCommissionMapper, MonthFeeCommissionEntity>
implements IMonthFeeCommissionService {
    @Autowired
    private IMonthFeeCommissionService service;
    @Autowired
    private IBusOpportunityService opportunityService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITenderFileService tenderFileService;
    @Autowired
    private ISupplementBidDocService supplementBidDocService;
    @Autowired
    private IBidOpenResultService bidOpenResultService;
    @Autowired
    private IBidPersonAffirmService bidPersonAffirmService;
    private final String northeastRegion = "\u4e1c\u5317\u5927\u533a";
    private final Long DBDQOrgId = 1940668587215687681L;
    private final String \u5317\u65b9\u4e00\u5efa = "\u5317\u65b9\u4e00\u5efa\u5efa\u8bbe\u96c6\u56e2\u516c\u53f8";
    private final Integer ORG_TYPE_PROJECT_MANAGER_ORG = 3;

    @Override
    public void generateMothFeeCommission() {
        this.logger.info("---------------\u81ea\u52a8\u751f\u6210\u6708\u5ea6 \u8d39\u7528\u63d0\u6210 \u62a5\u8868\u4efb\u52a1\u5f00\u59cb---------------");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year", (Object)DateUtil.format(new Date(), "yyyy"));
        query.eq((Object)"month", (Object)DateUtil.format(new Date(), "MM"));
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("---------------------\u5f53\u524d\u6708\u4efd\u5df2\u751f\u6210\u8d39\u7528\u63d0\u6210\u62a5\u8868\uff0c\u4e8c\u6b21\u751f\u6210\u5f00\u59cb---------------------");
            ArrayList<Long> ids = new ArrayList<Long>();
            HashSet<String> updOpprSetIds = new HashSet<String>();
            for (MonthFeeCommissionEntity monthFeeCommissionEntity : list) {
                ids.add(monthFeeCommissionEntity.getId());
                if (null == monthFeeCommissionEntity.getOpprIds()) continue;
                updOpprSetIds.addAll(Arrays.asList(StringUtils.split((String)monthFeeCommissionEntity.getOpprIds(), (String)",")));
            }
            this.service.removeByIds(ids, false);
            this.opportunityService.updateQuoteFlag(new ArrayList<Long>(updOpprSetIds), "0");
            this.logger.info("---------------------\u66f4\u65b0---------------------");
        }
        ArrayList<Long> updateOpprIds = new ArrayList<Long>();
        List<BusOpportunityVO> busOpportunityEntityList = this.opportunityService.getAllUnQuoteBill();
        if (CollectionUtils.isEmpty(busOpportunityEntityList)) {
            this.logger.info("---------------------\u5f53\u524d\u672a\u67e5\u8be2\u5230\u5df2\u751f\u6548\u4e14\u672a\u88ab\u751f\u6210\u8d39\u7528\u63d0\u6210\u62a5\u8868\u7684\u5546\u673a\u767b\u8bb0\u5355\u636e\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f---------------------");
            return;
        }
        HashSet<Long> emplyeeIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        for (BusOpportunityVO bp : busOpportunityEntityList) {
            if (null != bp.getFollowPersonId()) {
                emplyeeIds.add(bp.getFollowPersonId());
            }
            if (null != bp.getDocumenterId()) {
                emplyeeIds.add(bp.getDocumenterId());
            }
            if (null != bp.getNetAuthPersonId()) {
                emplyeeIds.add(bp.getNetAuthPersonId());
            }
            if (null != bp.getSiteAuthPersonId()) {
                emplyeeIds.add(bp.getSiteAuthPersonId());
            }
            orgIds.add(bp.getOrgId());
        }
        HashMap<Long, EmployeeVO> empIdMap = new HashMap<Long, EmployeeVO>();
        HashMap<Long, OrgVO> orgIdMap = new HashMap<Long, OrgVO>();
        HashMap<Long, MonthFeeCommissionEntity> monthFeeMap = new HashMap<Long, MonthFeeCommissionEntity>();
        ArrayList monthFeeList = new ArrayList();
        HashMap<Long, MonthFeeCommissionEntity> saveMap = new HashMap<Long, MonthFeeCommissionEntity>();
        HashMap<Long, HashSet<Long>> registrationIdsMap = new HashMap<Long, HashSet<Long>>();
        HashMap<Long, HashSet<Long>> fileIdsMap = new HashMap<Long, HashSet<Long>>();
        HashMap<Long, HashSet<Long>> authIdsMap = new HashMap<Long, HashSet<Long>>();
        HashMap<Long, HashSet<Long>> budgetIdsMap = new HashMap<Long, HashSet<Long>>();
        HashMap<Long, HashSet<Long>> bidDocIdsMap = new HashMap<Long, HashSet<Long>>();
        if (CollectionUtils.isNotEmpty(emplyeeIds)) {
            this.logger.info("\u67e5\u5230\u4eba\u5458\uff0cemplyeeIds:{}" + JSONObject.toJSONString(emplyeeIds));
            CommonResponse empList = this.employeeApi.getJustByIds(new ArrayList(emplyeeIds));
            if (!empList.isSuccess()) {
                this.logger.error("\u6839\u636e\u4eba\u5458id\u5217\u8868{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(emplyeeIds), (Object)JSONObject.toJSONString((Object)empList));
                return;
            }
            this.logger.info("\u67e5\u5230\u4eba\u5458\uff0cempList:{}", (Object)JSONObject.toJSONString((Object)empList));
            this.logger.info(JSONObject.toJSONString((Object)empList));
            if (CollectionUtils.isNotEmpty((Collection)((Collection)empList.getData()))) {
                for (EmployeeVO employee : (List)empList.getData()) {
                    if (1 != employee.getJobType()) continue;
                    empIdMap.put(employee.getId(), employee);
                    orgIds.add(employee.getOrgId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            CommonResponse orgResp = this.orgApi.findAllByIds(new ArrayList(orgIds));
            if (!orgResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7id\u5217\u8868{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(orgIds), (Object)JSONObject.toJSONString((Object)orgResp));
                return;
            }
            orgIdMap.putAll(((List)orgResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        EmployeeVO tmpEmp = null;
        MonthFeeCommissionEntity tmpFee = null;
        List<Long> areaList = Arrays.asList(1448851723325034588L, 1448851723325034518L, 1448851498992730150L, 1448851498984341553L, 1448851879822905473L, 1448851498803986433L);
        for (BusOpportunityVO bp : busOpportunityEntityList) {
            if (orgIdMap.containsKey(bp.getOrgId())) {
                bp.setOrgType(((OrgVO)orgIdMap.get(bp.getOrgId())).getOrgType());
            }
            if (null != bp.getFollowPersonId() && empIdMap.containsKey(bp.getFollowPersonId())) {
                tmpEmp = (EmployeeVO)empIdMap.get(bp.getFollowPersonId());
            }
            if (null != tmpEmp) {
                HashSet<Long> registrationIds;
                tmpFee = (MonthFeeCommissionEntity)((Object)monthFeeMap.get(tmpEmp.getId()));
                if (null == tmpFee) {
                    tmpFee = this.generateNewFee(tmpEmp, orgIdMap);
                    monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                }
                if (!(!areaList.contains(bp.getProvinceId()) && ComputeUtil.isGreaterThan((BigDecimal)new BigDecimal(2000), (BigDecimal)bp.getQualificationFee()) || areaList.contains(bp.getProvinceId()) && ComputeUtil.isGreaterThan((BigDecimal)new BigDecimal(1000), (BigDecimal)bp.getQualificationFee()))) {
                    tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getRegistrationMny()));
                    tmpFee.setRegistrationMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getRegistrationMny(), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)bp.getQualificationFee(), (BigDecimal)new BigDecimal("0.25"))));
                    tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getRegistrationMny(), (BigDecimal)tmpFee.getTotalMny()));
                }
                if (null == (registrationIds = (HashSet<Long>)registrationIdsMap.get(tmpEmp.getId()))) {
                    registrationIds = new HashSet<Long>();
                }
                registrationIds.add(bp.getId());
                registrationIdsMap.put(tmpEmp.getId(), registrationIds);
                monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                saveMap.put(tmpFee.getEmployeeId(), tmpFee);
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u4e1a\u52a1\u7ecf\u7406id-{}\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getFollowPersonId());
            }
            this.logger.error("\u8d44\u6599\u54581\u5546\u673a\u767b\u8bb0\u5355id-{}\u8d44\u6599\u5458id-{}", (Object)bp.getId(), (Object)bp.getDocumenterId());
            if (null != bp.getDocumenterId() && empIdMap.containsKey(bp.getDocumenterId())) {
                tmpEmp = (EmployeeVO)empIdMap.get(bp.getDocumenterId());
                this.logger.error("\u8d44\u6599\u54582\u5546\u673a\u767b\u8bb0\u5355id-{}\u8d44\u6599\u5458id-{}", (Object)bp.getId(), (Object)bp.getDocumenterId());
                if ("\u4e1c\u5317\u5927\u533a".equals(bp.getDocumenterOrgName())) {
                    this.logger.error("\u8d44\u6599\u54583\u5546\u673a\u767b\u8bb0\u5355id-{}\u8d44\u6599\u5458id-{}", (Object)bp.getId(), (Object)bp.getDocumenterId());
                    if (orgIdMap.containsKey(bp.getOrgId()) && !this.ORG_TYPE_PROJECT_MANAGER_ORG.equals(((OrgVO)orgIdMap.get(bp.getOrgId())).getOrgType())) {
                        List<TenderFileEntity> fileList = this.tenderFileService.getByBusOpportunityId(bp.getId());
                        this.logger.error("\u8d44\u6599\u54584\u5546\u673a\u767b\u8bb0\u5355id-{}\u8d44\u6599\u5458id-{}fileList-{}fileListSize-{}", new Object[]{bp.getId(), bp.getDocumenterId(), fileList, fileList.size()});
                        if (CollectionUtils.isNotEmpty(fileList)) {
                            this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{}\u8d44\u6599\u5458id-{} fileList-{}\u8d44\u6599\u4e0a\u4f2011111~", new Object[]{bp.getId(), bp.getDocumenterId(), fileList});
                            tmpFee = (MonthFeeCommissionEntity)((Object)monthFeeMap.get(tmpEmp.getId()));
                            if (null == tmpFee) {
                                tmpFee = this.generateNewFee(tmpEmp, orgIdMap);
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getFileMny()));
                            tmpFee.setFileMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getFileMny(), (BigDecimal)new BigDecimal("40")));
                            tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getFileMny(), (BigDecimal)tmpFee.getTotalMny()));
                            HashSet<Long> fileIds = (HashSet<Long>)fileIdsMap.get(tmpEmp.getId());
                            if (null == fileIds) {
                                fileIds = new HashSet<Long>();
                            }
                            fileIds.add(bp.getId());
                            fileIdsMap.put(tmpEmp.getId(), fileIds);
                            monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                            saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                        } else {
                            this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6ca1\u6709\u751f\u6548\u7684\u8d44\u6599\u4e0a\u4f20\u5355\u636e\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getOrgId());
                        }
                    } else {
                        this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6240\u5c5e\u7ec4\u7ec7id-{}\u7c7b\u578b\u4e3a\u529e\u4e8b\u5904\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getOrgId());
                    }
                } else {
                    this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8d44\u6599\u5458id-{}\u76f4\u5c5e\u7ec4\u7ec7\u4e0d\u662f\u4e1c\u5317\u5927\u533a\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
                }
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8d44\u6599\u5458id-{}\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
            }
            tmpEmp = null;
            List<BidOpenResultEntity> openResultList = this.bidOpenResultService.getByBusOpportunityId(bp.getId());
            if (CollectionUtils.isNotEmpty(openResultList)) {
                BidOpenResultEntity result = openResultList.get(0);
                if ("\u7f51\u5f00".equals(result.getBidOpenType())) {
                    if (null != bp.getNetAuthPersonId()) {
                        tmpEmp = (EmployeeVO)empIdMap.get(bp.getNetAuthPersonId());
                    }
                } else if (null != bp.getSiteAuthPersonId()) {
                    tmpEmp = (EmployeeVO)empIdMap.get(bp.getNetAuthPersonId());
                }
                if (null == tmpEmp) {
                    this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6388\u6743\u4ebaid-{}\uff0c\u6388\u6743\u4eba\u7c7b\u578b\uff1a{}, \u67e5\u8be2\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406~", new Object[]{bp.getId(), bp.getDocumenterId(), result.getBidOpenType()});
                } else {
                    HashSet<Long> authIds;
                    tmpFee = (MonthFeeCommissionEntity)((Object)monthFeeMap.get(tmpEmp.getId()));
                    if (null == tmpFee) {
                        tmpFee = this.generateNewFee(tmpEmp, orgIdMap);
                    }
                    if ("\u7f51\u5f00".equals(result.getBidOpenType()) && "\u4e1c\u5317\u5927\u533a".equals(bp.getNetAuthPersonOrgName())) {
                        tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getAuthMny()));
                        tmpFee.setAuthMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getAuthMny(), (BigDecimal)new BigDecimal("30")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getAuthMny(), (BigDecimal)tmpFee.getTotalMny()));
                        authIds = (HashSet<Long>)authIdsMap.get(tmpEmp.getId());
                        if (null == authIds) {
                            authIds = new HashSet<Long>();
                        }
                        authIds.add(bp.getId());
                        authIdsMap.put(tmpEmp.getId(), authIds);
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    } else if ("\u73b0\u573a".equals(result.getBidOpenType()) && "\u4e1c\u5317\u5927\u533a".equals(bp.getSiteAuthPersonOrgName())) {
                        tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getAuthMny()));
                        tmpFee.setAuthMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getAuthMny(), (BigDecimal)new BigDecimal("100")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getAuthMny(), (BigDecimal)tmpFee.getTotalMny()));
                        authIds = (HashSet)authIdsMap.get(tmpEmp.getId());
                        if (null == authIds) {
                            authIds = new HashSet();
                        }
                        authIds.add(bp.getId());
                        authIdsMap.put(tmpEmp.getId(), authIds);
                        monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    } else {
                        this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6388\u6743\u4ebaid-{}\uff0c\u6388\u6743\u4eba\u7c7b\u578b\uff1a{}, \u76f4\u5c5e\u7ec4\u7ec7\u975e\u4e1c\u5317\u5927\u533a\uff0c\u8df3\u8fc7\u5904\u7406~", new Object[]{bp.getId(), bp.getDocumenterId(), result.getBidOpenType()});
                    }
                }
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u4e0d\u5b58\u5728\u751f\u6548\u7684\u5f00\u5305\u8bb0\u5f55\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
            }
            List<BidPersonAffirmEntity> bidPersonAffirmList = this.bidPersonAffirmService.getByBusOpportunityId(bp.getId());
            if (CollectionUtils.isNotEmpty(bidPersonAffirmList)) {
                CommonResponse empResp;
                ArrayList<Long> ids;
                BidPersonAffirmEntity bidPerson = bidPersonAffirmList.get(0);
                if ("\u5916\u5305\u9884\u7b97\u5458\uff08\u6210\u90fd\uff09".equals(bidPerson.getBudgetPersonName()) || "\u5916\u5305\u9884\u7b97\u5458\uff08\u957f\u6625\uff09".equals(bidPerson.getBudgetPersonName())) {
                    tmpEmp = (EmployeeVO)empIdMap.get(bidPerson.getBudgetPersonId());
                    if (null == tmpEmp) {
                        ids = new ArrayList<Long>();
                        ids.add(bidPerson.getBudgetPersonId());
                        empResp = this.employeeApi.getJustByIds(ids);
                        if (empResp.isSuccess()) {
                            this.logger.info("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8be2\u5230 \u9884\u7b97\u5458\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bidPerson.getBudgetPersonId());
                        }
                        for (EmployeeVO vo : (List)empResp.getData()) {
                            if (1 != vo.getJobType()) continue;
                            tmpEmp = vo;
                        }
                        empIdMap.put(bidPerson.getBudgetPersonId(), tmpEmp);
                    }
                    if (null != tmpEmp) {
                        tmpFee = (MonthFeeCommissionEntity)((Object)monthFeeMap.get(tmpEmp.getId()));
                        if (null == tmpFee) {
                            tmpFee = this.generateNewFee(tmpEmp, orgIdMap);
                        }
                        tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getBudgetMny()));
                        tmpFee.setBudgetMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getBudgetMny(), (BigDecimal)new BigDecimal("200")));
                        tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getBudgetMny(), (BigDecimal)tmpFee.getTotalMny()));
                        HashSet<Long> budgetIds = (HashSet<Long>)budgetIdsMap.get(tmpEmp.getId());
                        if (null == budgetIds) {
                            budgetIds = new HashSet<Long>();
                        }
                        budgetIds.add(bp.getId());
                        budgetIdsMap.put(tmpEmp.getId(), budgetIds);
                        monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                        saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                    } else {
                        this.logger.info("\u5546\u673a\u767b\u8bb0\u5355id-{} \u672a\u67e5\u8be2\u5230 \u56fa\u5b9a\u4eba\u5458[\u9884\u7b97\u5458\uff08\u6210\u90fd\uff09\u3001\u9884\u7b97\u5458\uff08\u957f\u6625\uff09]\u4fe1\u606f\uff0c\u8df3\u8fc7\u5904\u7406~");
                    }
                } else {
                    this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6807\u4e66\u786e\u8ba4\u5355\u636e\u4e2d\u9884\u7b97\u5458\u975e\u6307\u5b9a\u7684 \u56fa\u5b9a\u4eba\u5458[\u9884\u7b97\u5458\uff08\u6210\u90fd\uff09\u3001\u9884\u7b97\u5458\uff08\u957f\u6625\uff09]\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
                }
                if (null != bidPerson.getBidPersonId()) {
                    tmpEmp = (EmployeeVO)empIdMap.get(bidPerson.getBidPersonId());
                    if (null == tmpEmp) {
                        ids = new ArrayList();
                        ids.add(bidPerson.getBidPersonId());
                        empResp = this.employeeApi.getJustByIds(ids);
                        if (empResp.isSuccess()) {
                            this.logger.info("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8be2\u5230 \u6807\u4e66\u4eba\u5458id-{} \u6570\u636e\u4fe1\u606f-{}++++++{}\u4fe1\u606f\u5931\u8d25\uff0c\u8df3\u8fc7\u5904\u7406~", new Object[]{bp.getId(), bidPerson.getBidPersonId(), JSONObject.toJSONString((Object)empResp.getData())});
                        }
                        for (EmployeeVO vo : (List)empResp.getData()) {
                            if (1 != vo.getJobType()) continue;
                            tmpEmp = vo;
                        }
                        empIdMap.put(bidPerson.getBidPersonId(), tmpEmp);
                    }
                    if (null != tmpEmp) {
                        List<SupplementBidDocEntity> docList = this.supplementBidDocService.getByBusOpportunityId(bp.getId());
                        if (CollectionUtils.isNotEmpty(docList)) {
                            tmpFee = (MonthFeeCommissionEntity)((Object)monthFeeMap.get(tmpEmp.getId()));
                            if (null == tmpFee) {
                                tmpFee = this.generateNewFee(tmpEmp, orgIdMap);
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeSub((BigDecimal)tmpFee.getTotalMny(), (BigDecimal)tmpFee.getBidDocMny()));
                            if ("\u4e1c\u5317\u5927\u533a".equals(bidPerson.getBidPersonOrgName())) {
                                tmpFee.setBidDocMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getBidDocMny(), (BigDecimal)new BigDecimal("200")));
                            }
                            if ("\u5317\u65b9\u4e00\u5efa\u5efa\u8bbe\u96c6\u56e2\u516c\u53f8".equals(bidPerson.getBidPersonOrgName())) {
                                tmpFee.setBidDocMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getBidDocMny(), (BigDecimal)new BigDecimal("150")));
                            }
                            tmpFee.setTotalMny(ComputeUtil.safeAdd((BigDecimal)tmpFee.getBidDocMny(), (BigDecimal)tmpFee.getTotalMny()));
                            HashSet<Long> bidDocIds = (HashSet<Long>)bidDocIdsMap.get(tmpEmp.getId());
                            if (null == bidDocIds) {
                                bidDocIds = new HashSet<Long>();
                            }
                            bidDocIds.add(bp.getId());
                            bidDocIdsMap.put(tmpEmp.getId(), bidDocIds);
                            monthFeeMap.put(tmpFee.getEmployeeId(), tmpFee);
                            saveMap.put(tmpFee.getEmployeeId(), tmpFee);
                        } else {
                            this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6ca1\u6709\u751f\u6548\u7684\u4e0a\u4f20\u6807\u4e66\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getOrgId());
                        }
                    } else {
                        this.logger.info("\u5546\u673a\u767b\u8bb0\u5355id-{} \u672a\u67e5\u8be2\u5230 \u6807\u4e66\u4eba\u5458id-{}\u4fe1\u606f\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bidPerson.getBidPersonId());
                    }
                } else {
                    this.logger.info("\u5546\u673a\u767b\u8bb0\u5355id-{} \u672a\u67e5\u8be2\u5230 \u6807\u4e66\u4eba\u5458id-{}\u4fe1\u606f\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bidPerson.getBidPersonId());
                }
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u4e0d\u5b58\u5728\u751f\u6548\u7684\u786e\u8ba4\u6807\u4e66\u5458\u5355\u636e\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
            }
            updateOpprIds.add(bp.getId());
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u5546\u673a{}\u6761", (Object)updateOpprIds.size());
        if (CollectionUtils.isNotEmpty(updateOpprIds)) {
            this.opportunityService.updateQuoteFlag(updateOpprIds, "1");
        }
        monthFeeList.addAll(saveMap.values());
        if (CollectionUtils.isNotEmpty(monthFeeList)) {
            monthFeeList.forEach(e -> {
                e.setTenantId(888888L);
                e.setOpprIds(StringUtil.join((Collection)updateOpprIds, (String)","));
                e.setRegistrationIds(StringUtil.join((Collection)((Collection)registrationIdsMap.get(e.getEmployeeId())), (String)","));
                e.setAuthIds(StringUtil.join((Collection)((Collection)authIdsMap.get(e.getEmployeeId())), (String)","));
                e.setBudgetIds(StringUtil.join((Collection)((Collection)budgetIdsMap.get(e.getEmployeeId())), (String)","));
                e.setFileIds(StringUtil.join((Collection)((Collection)fileIdsMap.get(e.getEmployeeId())), (String)","));
                e.setBidDocIds(StringUtil.join((Collection)((Collection)bidDocIdsMap.get(e.getEmployeeId())), (String)","));
            });
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e", (Object)JSONObject.toJSONString(saveMap.values()));
            this.service.saveOrUpdateBatch(monthFeeList, monthFeeList.size(), false);
        }
        this.logger.info("---------------\u81ea\u52a8\u751f\u6210\u6708\u5ea6 \u8d39\u7528\u63d0\u6210 \u62a5\u8868\u4efb\u52a1\u6267\u884c\u7ed3\u675f---------------");
    }

    @Override
    public List<MonthFeeCommissionEntity> getByBusOpportunityId(Long id) {
        BusOpportunityEntity bp = (BusOpportunityEntity)((Object)this.opportunityService.selectById(id));
        HashSet<Long> emplyeeIds = new HashSet<Long>();
        if (null != bp.getFollowPersonId()) {
            emplyeeIds.add(bp.getFollowPersonId());
        }
        if (null != bp.getDocumenterId()) {
            emplyeeIds.add(bp.getDocumenterId());
        }
        if (null != bp.getNetAuthPersonId()) {
            emplyeeIds.add(bp.getNetAuthPersonId());
        }
        if (null != bp.getSiteAuthPersonId()) {
            emplyeeIds.add(bp.getSiteAuthPersonId());
        }
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"employee_id", emplyeeIds);
        query.eq((Object)"month", (Object)String.valueOf(bp.getCreateTime().getMonth()));
        query.eq((Object)"year", (Object)String.valueOf(bp.getCreateTime().getYear()));
        query.orderByDesc((Object)"create_time");
        return super.list((Wrapper)query);
    }

    private MonthFeeCommissionEntity generateNewFee(EmployeeVO tmpEmp, Map<Long, OrgVO> orgIdMap) {
        MonthFeeCommissionEntity tmpFee = new MonthFeeCommissionEntity();
        tmpFee.setEmployeeId(tmpEmp.getId());
        tmpFee.setEmployeeCode(tmpEmp.getCode());
        tmpFee.setEmployeeName(tmpEmp.getName());
        tmpFee.setPostName(tmpEmp.getPostName());
        tmpFee.setDeptName(tmpEmp.getDeptName());
        this.logger.error("----------------\u5b9e\u4f53{}++++++postname{}deptname{}", new Object[]{JSONObject.toJSONString((Object)tmpEmp), tmpEmp.getPostName(), tmpEmp.getDeptName()});
        tmpFee.setOrgId(tmpEmp.getOrgId());
        tmpFee.setYear(DateUtil.format(new Date(), "yyyy"));
        tmpFee.setMonth(DateUtil.format(new Date(), "MM"));
        tmpFee.setBillDate(new Date());
        if (orgIdMap.containsKey(tmpEmp.getOrgId())) {
            tmpFee.setOrgCode(orgIdMap.get(tmpEmp.getOrgId()).getCode());
            tmpFee.setOrgName(orgIdMap.get(tmpEmp.getOrgId()).getName());
            tmpEmp.setOrgName(tmpFee.getOrgName());
        }
        tmpFee.setTotalMny(BigDecimal.ZERO);
        tmpFee.setBudgetMny(BigDecimal.ZERO);
        tmpFee.setAuthMny(BigDecimal.ZERO);
        tmpFee.setBidDocMny(BigDecimal.ZERO);
        tmpFee.setRegistrationMny(BigDecimal.ZERO);
        tmpFee.setFileMny(BigDecimal.ZERO);
        return tmpFee;
    }
}

