/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tax.bean.CostRatioEntity;
import com.ejianc.business.tax.service.ICostRatioService;
import com.ejianc.business.tax.vo.CostRatioVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"costRatio"})
public class CostRatioController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICostRatioService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostRatioVO> saveOrUpdate(@RequestBody CostRatioVO saveOrUpdateVO) {
        CostRatioEntity entity = (CostRatioEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CostRatioEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CostRatioVO vo = (CostRatioVO)BeanMapper.map((Object)((Object)entity), CostRatioVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostRatioVO> queryDetail(Long id) {
        CostRatioEntity entity = (CostRatioEntity)((Object)this.service.selectById(id));
        CostRatioVO vo = (CostRatioVO)BeanMapper.map((Object)((Object)entity), CostRatioVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostRatioVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CostRatioVO costRatioVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostRatioVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("businessName", "buildDate", "year"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostRatioVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("businessName", "buildDate", "year"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("CostRatio-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"CostRatio-import.xlsx", (String)"\u5bfc\u5165\u6210\u672c\u6bd4\u4f8b\u5206\u6790");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CostRatioVO> successList = new ArrayList<CostRatioVO>();
        ArrayList<CostRatioVO> errorList = new ArrayList<CostRatioVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 5) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        for (int i = 0; i < result.size(); ++i) {
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            CostRatioVO vo = new CostRatioVO();
            String businessName = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)businessName)) {
                vo.setBusinessName(businessName);
            } else {
                errMsg.append("`\u4f01\u4e1a\u540d\u79f0\u672a\u586b\u5199`");
            }
            String buildDate = (String)row.get(1);
            if (StringUtils.isNotBlank((CharSequence)buildDate)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                GregorianCalendar calendar = new GregorianCalendar(1900, 0, -1);
                Date date = DateUtils.addDays((Date)calendar.getTime(), (int)Integer.valueOf(buildDate));
                Object parse = null;
                vo.setBuildDate(date);
            } else {
                errMsg.append("`\u6210\u7acb\u65e5\u671f\u672a\u586b\u5199`");
            }
            String year = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)year)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                Date parse = null;
                try {
                    parse = simpleDateFormat.parse(year);
                    vo.setYear(parse);
                }
                catch (ParseException e) {
                    errMsg.append("`\u5e74\u4efd\u683c\u5f0f\u9519\u8bef`");
                }
            } else {
                errMsg.append("`\u5e74\u4efd\u672a\u586b\u5199`");
            }
            String incomeMny = ((String)row.get(3)).trim();
            if (StringUtils.isNotBlank((CharSequence)incomeMny)) {
                vo.setIncomeMny(ComputeUtil.toBigDecimal((String)incomeMny));
            } else {
                errMsg.append("`\u6536\u5165\u91d1\u989d\u672a\u586b\u5199`");
            }
            String costMny = ((String)row.get(4)).trim();
            if (StringUtils.isNotBlank((CharSequence)costMny)) {
                vo.setCostMny(ComputeUtil.toBigDecimal((String)costMny));
            } else {
                errMsg.append("`\u6210\u672c\u91d1\u989d\u672a\u586b\u5199`");
            }
            vo.setErrMsg(errMsg.toString());
            vo.setRatio(ComputeUtil.bigDecimalPercent((BigDecimal)vo.getCostMny(), (BigDecimal)vo.getIncomeMny(), (int)2));
            if (StringUtils.isNotBlank((CharSequence)vo.getErrMsg())) {
                errorList.add(vo);
                continue;
            }
            successList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, CostRatioVO.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<CostRatioVO> costRatioVOS) {
        this.service.saveBatch(BeanMapper.mapList(costRatioVOS, CostRatioEntity.class));
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/refCostRatioData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CostRatioVO>> refCostRatioData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostRatioVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

