/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectBillVO;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.cost.vo.ProjectReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectBill"})
public class ProjectBillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_CBKJ_XMDZ";
    @Autowired
    private IProjectBillService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectBillVO> saveOrUpdate(@RequestBody ProjectBillVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.insertOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectBillVO> queryDetail(Long id) {
        ProjectBillEntity entity = (ProjectBillEntity)((Object)this.service.selectById(id));
        ProjectBillVO vo = (ProjectBillVO)BeanMapper.map((Object)((Object)entity), ProjectBillVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectBillVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectBillVO vo : vos) {
                this.service.removeDataByProjectBillId(vo.getId());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectBillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, ProjectBillVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("ProjectBill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectBillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectBillVO>> refProjectBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProjectBillDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectBillVO> queryProjectBillDataByProjectId(String projectId, Long projectBillId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.notIn((Object)"bill_state", Arrays.asList(1, 3));
        if (null != projectBillId) {
            queryWrapper.ne((Object)"id", (Object)projectBillId);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        List entityList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 0) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u7684\u9879\u76ee\u5bf9\u8d26\u5355\uff01");
        }
        entityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", Arrays.asList(1, 3))).orderByDesc((Object)"create_time"));
        ProjectBillVO projectBillVO = this.service.queryProjectBillDataByProjectId(projectId, entityList);
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76eeid\u67e5\u8be2\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01", (Object)projectBillVO);
    }

    @RequestMapping(value={"/queryProjectReportByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectReportVO> queryProjectReportByProjectId(Long projectId) {
        ProjectReportVO projectReportVO = this.service.queryProjectReportByProjectId(projectId);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List entityList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 0) {
            projectReportVO.setDifPlaceAdvanceTax(entityList.stream().filter(item -> null != item.getDifPlaceAdvanceTax()).map(ProjectBillEntity::getDifPlaceAdvanceTax).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        QueryWrapper queryProjectWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page(1L, 10000L);
        List<ProjectDetailBillVO> pageData = this.service.pageList((Page<ProjectDetailBillVO>)page, (QueryWrapper<ProjectDetailBillVO>)queryProjectWrapper);
        if (CollectionUtils.isNotEmpty(pageData) && pageData.size() > 0) {
            BigDecimal balance = BigDecimal.ZERO;
            for (ProjectDetailBillVO data : pageData) {
                balance = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO), (BigDecimal)balance), (BigDecimal)(null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO));
                data.setBalance(balance);
            }
            projectReportVO.setLeaveUsableCost(null != pageData && pageData.size() > 1 ? pageData.get(pageData.size() - 1).getBalance() : BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u770b\u677f\u6570\u636e\u6210\u529f\uff01", (Object)projectReportVO);
    }
}

