package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.mapper.BidOpenResultMapper;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 投标管理-开标结果
 * 
 * @author generator
 * 
 */
@Service("bidOpenResultService")
public class BidOpenResultServiceImpl extends BaseServiceImpl<BidOpenResultMapper, BidOpenResultEntity> implements IBidOpenResultService {

    @Override
    public List<BidOpenResultEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<BidOpenResultEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
