package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.ProjectRegistrationEntity;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IProjectRegistrationService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.vo.BusOpportunityVO;

/**
 * 投标管理-商机登记实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("busOpportunity")
public class BusOpportunityController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID-BUS-OPPORTUNITY";//此处需要根据实际修改

    @Autowired
    private IBusOpportunityService service;
    @Autowired
    private IBidOpenResultService resultService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-54I9z490";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusOpportunityVO> saveOrUpdate(@RequestBody BusOpportunityVO saveOrUpdateVO) {
        BusOpportunityEntity entity = BeanMapper.map(saveOrUpdateVO, BusOpportunityEntity.class);

        Boolean sendFlag = false;
    	if(entity.getId() == null || entity.getId() == 0){
            sendFlag = true;
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            BusOpportunityEntity oldEntity = service.selectById(entity.getId());
            if (null != oldEntity && (oldEntity.getDocumenterId().longValue() != entity.getDocumenterId().longValue())){
                sendFlag = true;
            }
        }

    	//查询引用项目包名单是否已被引用
        List<BusOpportunityEntity> dbList = service.getAllByRegistrationId(saveOrUpdateVO.getRegistrationId(), entity.getId());
    	if(CollectionUtils.isNotEmpty(dbList)) {
    	    return CommonResponse.error("操作失败，当前项目报名单已被引用！");
        }

    	service.saveOrUpdate(entity, false);
        if (sendFlag) {
            service.sendMsgToDocumenter(entity);
        }
    	BusOpportunityVO vo = BeanMapper.map(entity, BusOpportunityVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusOpportunityVO> queryDetail(Long id) {
    	BusOpportunityEntity entity = service.selectById(id);
    	BusOpportunityVO vo = BeanMapper.map(entity, BusOpportunityVO.class);
        if (canUpdateAll()){
            vo.setUpdateCheckStatusFlag(1);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    public Boolean canUpdateAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode())) return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusOpportunityVO> vos) {
        service.removeByIds(vos.stream().map(BusOpportunityVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusOpportunityVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("provinceName");
        fuzzyFields.add("cityName");
        fuzzyFields.add("regionName");
        fuzzyFields.add("qualificationUnitName");
        fuzzyFields.add("qualificationTypeName");
        fuzzyFields.add("qualificationLevelName");
        fuzzyFields.add("managerMajorName");
        fuzzyFields.add("managerLevelName");
        fuzzyFields.add("techLevelName");
        fuzzyFields.add("projectPeriod");
        fuzzyFields.add("followPerson");
        fuzzyFields.add("netAuthPersonName");
        fuzzyFields.add("siteAuthPersonName");
        fuzzyFields.add("remittanceName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BusOpportunityEntity> page = service.queryPage(param,false);
        IPage<BusOpportunityVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //查询开标类型
        List<BusOpportunityVO> busOpportunityVOList = BeanMapper.mapList(page.getRecords(), BusOpportunityVO.class);
        List<Long> ids = busOpportunityVOList.stream().map(BusOpportunityVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)){
            LambdaQueryWrapper<BidOpenResultEntity> rqw = Wrappers.lambdaQuery();
            rqw.in(BidOpenResultEntity::getOpportunityId,ids)
                    .eq(BidOpenResultEntity::getDr,0);
            List<BidOpenResultEntity> list = resultService.list(rqw);
            Map<Long, BidOpenResultEntity> resultEntityMap = list.stream().collect(Collectors.toMap(BidOpenResultEntity::getOpportunityId
                    , Function.identity(), (v1, v2) -> v2));
            for (BusOpportunityVO busOpportunityVO : busOpportunityVOList) {
                if (null != resultEntityMap.get(busOpportunityVO.getId())) {
                    busOpportunityVO.setBidOpenType(resultEntityMap.get(busOpportunityVO.getId()).getBidOpenType());
                }
            }
        }

        pageData.setRecords(busOpportunityVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("provinceName");
        fuzzyFields.add("cityName");
        fuzzyFields.add("regionName");
        fuzzyFields.add("qualificationUnitName");
        fuzzyFields.add("qualificationTypeName");
        fuzzyFields.add("qualificationLevelName");
        fuzzyFields.add("managerMajorName");
        fuzzyFields.add("managerLevelName");
        fuzzyFields.add("techLevelName");
        fuzzyFields.add("projectPeriod");
        fuzzyFields.add("followPerson");
        fuzzyFields.add("netAuthPersonName");
        fuzzyFields.add("siteAuthPersonName");
        fuzzyFields.add("remittanceName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BusOpportunityEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BusOpportunity-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBusOpportunityData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BusOpportunityVO>> refBusOpportunityData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //查询生效的
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()})));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("isBidWinning")) {
                param.getParams().put("isBidWinning", new Parameter(QueryParam.EQ, 1));
            }
            if (_con.containsKey("isBidWinningFlag")) {
                param.getParams().put("isBidWinningFlag", new Parameter(QueryParam.EQ, 1));
            }
            if (null != _con.get("selfFlag")){
                ComplexParam c4 = new ComplexParam();
                c4.setLogic("and");
                ComplexParam c5 = new ComplexParam();
                c5.setLogic("or");
                c5.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
                c4.getComplexParams().add(c5);
                ComplexParam c6 = new ComplexParam();
                c6.setLogic("or");
                c6.getParams().put("documenterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
                c4.getComplexParams().add(c6);
                param.getComplexParams().add(c4);
            }
            if (null != _con.get("userFlag")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            }
        }

        IPage<BusOpportunityEntity> page = service.queryPage(param,false);
        IPage<BusOpportunityVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusOpportunityVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
