package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 出纳资金-零星付款申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_sporadic")
public class PaySporadicEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="memo")
    private String memo; // 付款事由
    @TableField(value="contract_type")
    private Integer contractType; // 费用类型：1-分包,2-设备,3-物资采购,4-其他支出合同
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="project_type")
    private String projectType; // 是否属于项目 1-项目，2-公司
    @TableField(value="project_type_name")
    private String projectTypeName; // 是否属于项目 1-项目，2-公司
    @TableField(value="pay_type")
    private Integer payType; // 支付类型：1-运营支出,2-项目支出,3-往来款
    @TableField(value="two_category_id")
    private Long twoCategoryId; // 二级分类
    @TableField(value="two_category_name")
    private String twoCategoryName; // 二级分类名称
    @TableField(value="supply_id")
    private Long supplyId; // 供应商
    @TableField(value="supply_code")
    private String supplyCode; // 供应商编码
    @TableField(value="supply_name")
    private String supplyName; // 供应商名称
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="bank_account")
    private String bankAccount; // 对方账户
    @TableField(value="bank_name")
    private String bankName; // 对方开户行
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称

    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="un_pay_mny")
    private BigDecimal unPayMny; // 未支付金额
    @TableField(value="confirm_time")
    private Date confirmTime; // 支付时间


    @TableField(value="customer_id")
    private Long customerId; // 甲方ID
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方ID
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="prouse_tax_mny")
    private BigDecimal prouseTaxMny; // 项目可用资金
    @TableField(value="account_name")
    private String accountName; // 对方账户户名
    @TableField(value="bear_dept_id")
    private Long bearDeptId; // 费用承担部门
    @TableField(value="bear_dept")
    private String bearDept; // 费用承担部门
    @TableField(value="pay_unit_id")
    private Long payUnitId; // 付款单位
    @TableField(value="pay_unit_name")
    private String payUnitName; // 付款单位
    @TableField(value="apply_mny_cn")
    private String applyMnyCn; // 申请金额大写
    @TableField(exist=false)
    @SubEntity(serviceName="paySporadicDetailService")
    private List<PaySporadicDetailEntity> detailList = new ArrayList<>();

    public List<PaySporadicDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PaySporadicDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Long getBearDeptId() {
        return bearDeptId;
    }

    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }

    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }

    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getProuseTaxMny() {
        return prouseTaxMny;
    }

    public void setProuseTaxMny(BigDecimal prouseTaxMny) {
        this.prouseTaxMny = prouseTaxMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }



    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Long getTwoCategoryId() {
        return twoCategoryId;
    }

    public void setTwoCategoryId(Long twoCategoryId) {
        this.twoCategoryId = twoCategoryId;
    }
    public String getTwoCategoryName() {
        return twoCategoryName;
    }

    public void setTwoCategoryName(String twoCategoryName) {
        this.twoCategoryName = twoCategoryName;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
