package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.OilRechargeEntity;
import com.ejianc.business.oa.bean.OilUseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 油卡登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_oil")
public class OilEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编号
    @TableField(value="oil_card")
    private String oilCard; // 油卡账号
    @TableField(value="mny")
    private BigDecimal mny; // 卡内余额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_code")
    private String employeeCode; // 经办人编码
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称

    @TableField(exist=false)
    @SubEntity(serviceName="oilRechargeService",pidName = "pid")
    private List<OilRechargeEntity> oilRechargeList = new ArrayList<>(); // 油卡充值明细
    @TableField(exist=false)
    @SubEntity(serviceName="oilUseService",pidName = "pid")
    private List<OilUseEntity> oilUseList = new ArrayList<>(); // 油卡使用明细
    @TableField(value="time")
    private Date time; // 时间

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOilCard() {
        return oilCard;
    }

    public void setOilCard(String oilCard) {
        this.oilCard = oilCard;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    

    public List<OilRechargeEntity> getOilRechargeList() {
        return oilRechargeList;
    }

    public void setOilRechargeList(List<OilRechargeEntity> oilRechargeList) {
        this.oilRechargeList = oilRechargeList;
    }

    public List<OilUseEntity> getOilUseList() {
        return oilUseList;
    }

    public void setOilUseList(List<OilUseEntity> oilUseList) {
        this.oilUseList = oilUseList;
    }
}
