package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-员工转正审批表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_formal")
public class EmployeeFormalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 员工编号
    @TableField(value="employee_id")
    private Long employeeId; // 员工名称
    @TableField(value="name")
    private String name; // 员工名称
    @TableField(value="org_id")
    private Long orgId; // 区域ID
    @TableField(value="org_name")
    private String orgName; // 区域
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 岗位ID
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="into_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @TableField(value="formal_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date formalDate; // 转正日期
    @TableField(value="try_date_begin")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDateBegin; // 试用日期
    @TableField(value="try_date_end")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDateEnd; // 试用日期
    @TableField(value="contract_term")
    private Integer contractTerm; // 合同年限
    @TableField(value="contract_date_begin")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateBegin; // 合同时间
    @TableField(value="contract_date_end")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateEnd; // 合同时间
    @TableField(value="rank")
    private Integer rank; // 职级
    @TableField(value="rank_name")
    private String rankName; // 职级
    @TableField(value="salary")
    private BigDecimal salary; // 薪资标准
    @TableField(value="basic_salary")
    private BigDecimal basicSalary; // 基本薪资
    @TableField(value="cert_salary")
    private BigDecimal certSalary; // 证书津贴
    @TableField(value="post_salary")
    private BigDecimal postSalary; // 岗位薪资
    @TableField(value="level_salary")
    private BigDecimal levelSalary; // 层级薪资
    @TableField(value="insured_flag")
    private Integer insuredFlag; // 是否缴纳保险
    @TableField(value="insured_flag_name")
    private String insuredFlagName; // 是否缴纳保险
    @TableField(value="insured_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredDate; // 缴纳时间
    @TableField(value="insured_type")
    private String insuredType; // 保险种类
    @TableField(value="insured_type_name")
    private String insuredTypeName; // 保险种类
    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    @TableField(value="educated_salary")
    private BigDecimal educatedSalary; // 学历津贴
    @TableField(value="sport_salary")
    private BigDecimal sportSalary; // 交通补助
    @TableField(value="begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 发放起止时间
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="year_salary_id")
    private Long yearSalaryId; // 司龄津贴
    @TableField(value="year_salary")
    private BigDecimal yearSalary; // 司龄津贴
    @TableField(value="year_change_date")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date yearChangeDate; // 司龄调整月份
    @TableField(value="year_salary_init")
    private BigDecimal yearSalaryInit; // 司龄津贴初始值
    @TableField(value="other_need_pay")
    private BigDecimal otherNeedPay; // 其他应付

    public BigDecimal getYearSalaryInit() {
        return yearSalaryInit;
    }

    public void setYearSalaryInit(BigDecimal yearSalaryInit) {
        this.yearSalaryInit = yearSalaryInit;
    }


    public BigDecimal getOtherNeedPay() {
        return otherNeedPay;
    }

    public void setOtherNeedPay(BigDecimal otherNeedPay) {
        this.otherNeedPay = otherNeedPay;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getFormalDate() {
        return formalDate;
    }

    public void setFormalDate(Date formalDate) {
        this.formalDate = formalDate;
    }

    public Date getTryDateBegin() {
        return tryDateBegin;
    }

    public void setTryDateBegin(Date tryDateBegin) {
        this.tryDateBegin = tryDateBegin;
    }

    public Date getTryDateEnd() {
        return tryDateEnd;
    }

    public void setTryDateEnd(Date tryDateEnd) {
        this.tryDateEnd = tryDateEnd;
    }

    public Integer getContractTerm() {
        return contractTerm;
    }

    public void setContractTerm(Integer contractTerm) {
        this.contractTerm = contractTerm;
    }

    public Date getContractDateBegin() {
        return contractDateBegin;
    }

    public void setContractDateBegin(Date contractDateBegin) {
        this.contractDateBegin = contractDateBegin;
    }

    public Date getContractDateEnd() {
        return contractDateEnd;
    }

    public void setContractDateEnd(Date contractDateEnd) {
        this.contractDateEnd = contractDateEnd;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public Date getInsuredDate() {
        return insuredDate;
    }

    public void setInsuredDate(Date insuredDate) {
        this.insuredDate = insuredDate;
    }
    public String getInsuredType() {
        return insuredType;
    }

    public void setInsuredType(String insuredType) {
        this.insuredType = insuredType;
    }
    public String getInsuredTypeName() {
        return insuredTypeName;
    }

    public void setInsuredTypeName(String insuredTypeName) {
        this.insuredTypeName = insuredTypeName;
    }
    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getYearSalaryId() {
        return yearSalaryId;
    }

    public void setYearSalaryId(Long yearSalaryId) {
        this.yearSalaryId = yearSalaryId;
    }
    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }
    public Date getYearChangeDate() {
        return yearChangeDate;
    }

    public void setYearChangeDate(Date yearChangeDate) {
        this.yearChangeDate = yearChangeDate;
    }
    
}
