/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.business.oa.service.impl.BackFeeServiceImpl;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"busOpportunity"})
public class BusOpportunityController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID-BUS-OPPORTUNITY";
    @Autowired
    private IBusOpportunityService service;
    @Autowired
    private IBidOpenResultService resultService;
    @Autowired
    private BackFeeServiceImpl backFeeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-54I9z490";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusOpportunityVO> saveOrUpdate(@RequestBody BusOpportunityVO saveOrUpdateVO) {
        List<BusOpportunityEntity> dbList;
        BusOpportunityEntity entity = (BusOpportunityEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BusOpportunityEntity.class));
        Boolean sendFlag = false;
        if (entity.getId() == null || entity.getId() == 0L) {
            sendFlag = true;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            BusOpportunityEntity oldEntity = (BusOpportunityEntity)((Object)this.service.selectById(entity.getId()));
            if (null != oldEntity && oldEntity.getDocumenterId().longValue() != entity.getDocumenterId().longValue()) {
                sendFlag = true;
            }
        }
        if (CollectionUtils.isNotEmpty(dbList = this.service.getAllByRegistrationId(saveOrUpdateVO.getRegistrationId(), entity.getId()))) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u62a5\u540d\u5355\u5df2\u88ab\u5f15\u7528\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (sendFlag.booleanValue()) {
            this.service.sendMsgToDocumenter(entity);
        }
        BusOpportunityVO vo = (BusOpportunityVO)BeanMapper.map((Object)((Object)entity), BusOpportunityVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BusOpportunityVO> queryDetail(Long id) {
        BusOpportunityEntity entity = (BusOpportunityEntity)((Object)this.service.selectById(id));
        BusOpportunityVO vo = (BusOpportunityVO)BeanMapper.map((Object)((Object)entity), BusOpportunityVO.class);
        if (this.canUpdateAll().booleanValue()) {
            vo.setUpdateCheckStatusFlag(Integer.valueOf(1));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByRegistrationId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BusOpportunityVO> queryDetailByRegistrationId(Long projectRegistrationId) {
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"registration_id", (Object)projectRegistrationId)).orderByDesc((Object)"create_time");
        List list = this.service.list((Wrapper)query);
        BusOpportunityVO busOpportunityVO = new BusOpportunityVO();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            busOpportunityVO = (BusOpportunityVO)BeanMapper.map(list.get(0), BusOpportunityVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)busOpportunityVO);
    }

    @RequestMapping(value={"/queryDetailByBusEntity"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailByBusEntity(Long busOpportunityId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("followPersonMmy", (Object)new BigDecimal(0));
        jsonObject.put("documenterMmy", (Object)new BigDecimal(0));
        jsonObject.put("authMmy", (Object)new BigDecimal(0));
        jsonObject.put("qualificationMmy", (Object)new BigDecimal(0));
        jsonObject.put("qualificationBackMmy", (Object)new BigDecimal(0));
        jsonObject.put("bidDocMny", (Object)new BigDecimal(0));
        jsonObject.put("bidDocBackMny", (Object)new BigDecimal(0));
        jsonObject.put("backMny", (Object)new BigDecimal(0));
        BusOpportunityEntity bp = (BusOpportunityEntity)((Object)this.service.selectById(busOpportunityId));
        this.backFeeService.queryDetailByBusEntity(bp, jsonObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    public Boolean canUpdateAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusOpportunityVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusOpportunityVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("provinceName");
        fuzzyFields.add("cityName");
        fuzzyFields.add("regionName");
        fuzzyFields.add("qualificationUnitName");
        fuzzyFields.add("qualificationTypeName");
        fuzzyFields.add("qualificationLevelName");
        fuzzyFields.add("managerMajorName");
        fuzzyFields.add("managerLevelName");
        fuzzyFields.add("techLevelName");
        fuzzyFields.add("projectPeriod");
        fuzzyFields.add("followPerson");
        fuzzyFields.add("netAuthPersonName");
        fuzzyFields.add("siteAuthPersonName");
        fuzzyFields.add("remittanceName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List busOpportunityVOList = BeanMapper.mapList((Iterable)page.getRecords(), BusOpportunityVO.class);
        List ids = busOpportunityVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper rqw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)rqw.in(BidOpenResultEntity::getOpportunityId, ids)).eq(BaseEntity::getDr, (Object)0);
            List list = this.resultService.list((Wrapper)rqw);
            Map resultEntityMap = list.stream().collect(Collectors.toMap(BidOpenResultEntity::getOpportunityId, Function.identity(), (v1, v2) -> v2));
            for (BusOpportunityVO busOpportunityVO : busOpportunityVOList) {
                if (null == resultEntityMap.get(busOpportunityVO.getId())) continue;
                busOpportunityVO.setBidOpenType(((BidOpenResultEntity)((Object)resultEntityMap.get(busOpportunityVO.getId()))).getBidOpenType());
            }
        }
        pageData.setRecords(busOpportunityVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("provinceName");
        fuzzyFields.add("cityName");
        fuzzyFields.add("regionName");
        fuzzyFields.add("qualificationUnitName");
        fuzzyFields.add("qualificationTypeName");
        fuzzyFields.add("qualificationLevelName");
        fuzzyFields.add("managerMajorName");
        fuzzyFields.add("managerLevelName");
        fuzzyFields.add("techLevelName");
        fuzzyFields.add("projectPeriod");
        fuzzyFields.add("followPerson");
        fuzzyFields.add("netAuthPersonName");
        fuzzyFields.add("siteAuthPersonName");
        fuzzyFields.add("remittanceName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BusOpportunity-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBusOpportunityData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BusOpportunityVO>> refBusOpportunityData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"isBidWinning")) {
                param.getParams().put("isBidWinning", new Parameter("eq", (Object)1));
            }
            if (_con.containsKey((Object)"isBidWinningFlag")) {
                param.getParams().put("isBidWinningFlag", new Parameter("eq", (Object)1));
            }
            if (null != _con.get((Object)"selfFlag")) {
                ComplexParam c4 = new ComplexParam();
                c4.setLogic("and");
                ComplexParam c5 = new ComplexParam();
                c5.setLogic("or");
                c5.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
                c4.getComplexParams().add(c5);
                ComplexParam c6 = new ComplexParam();
                c6.setLogic("or");
                c6.getParams().put("documenterId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
                c4.getComplexParams().add(c6);
                param.getComplexParams().add(c4);
            }
            if (null != _con.get((Object)"userFlag")) {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BusOpportunityVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

