package com.ejianc.business.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contract.bean.ContractChangeEntity;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.bean.ContractRecordEntity;
import com.ejianc.business.contract.service.IContractChangeService;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.service.IContractRecordService;
import com.ejianc.business.contract.vo.ContractManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("contractChange") 
public class ContractChangeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IContractChangeService changeService;

	@Autowired
	private IContractManageService contractService;


	@Autowired
	private IContractRecordService recordService;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ContractChangeEntity changeEntity = changeService.selectById(billId);
		LambdaUpdateWrapper<ContractChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractChangeEntity::getUsedTime, new Date());
		updateWrapper.eq(ContractChangeEntity::getId, changeEntity.getId());
		changeService.update(changeEntity, updateWrapper, false);
		/**更新变更的审批时间  end */

		/**复制合同表数据到记录表 begin */
		ContractManageVO contractVO = BeanMapper.map(contractService.selectById(changeEntity.getContractId()),ContractManageVO.class);
		Map<Long, Integer> contIdVersionMap =  new HashMap<>();
		ContractRecordEntity recordEntity = BeanMapper.map(contractVO, ContractRecordEntity.class);
		recordEntity.setContractId(recordEntity.getId());
		recordEntity.setId(null);
		recordService.saveOrUpdate(recordEntity, false);
		/**复制合同表数据到记录表 end */

		/**更新变更表表头数据到合同 begin */
		ContractManageEntity contractEntity = BeanMapper.map(contractVO, ContractManageEntity.class);
		contractEntity.setContractName(changeEntity.getContractName());
		contractEntity.setBillCode(changeEntity.getBillCode());
		contractEntity.setContractType(changeEntity.getContractType());
		contractEntity.setCustomerId(changeEntity.getCustomerId());
		contractEntity.setCustomerName(changeEntity.getCustomerName());
		contractEntity.setSupplierId(changeEntity.getSupplierId());
		contractEntity.setSupplierName(changeEntity.getSupplierName());
		contractEntity.setSignDate(changeEntity.getSignDate());
		contractEntity.setTaxRate(changeEntity.getTaxRate());
		contractEntity.setEmployeeId(changeEntity.getEmployeeId());
		contractEntity.setEmployeeName(changeEntity.getEmployeeName());
		contractEntity.setMemo(changeEntity.getMemo());
		contractEntity.setContractMny(changeEntity.getContractMny());
		contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
		contractEntity.setTaxMny(changeEntity.getTaxMny());
		contractEntity.setChangeStatus(3);
		contractEntity.setContractStatus(changeEntity.getContractStatus());
		boolean b = contractService.updateById(contractEntity);
		/**复制合同表数据到记录表 end */


		return CommonResponse.success("审批回调合同成功！");
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("合同变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
