package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 出纳资金-零星付款申请-费用明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_sporadic_detail")
public class PaySporadicDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="pid")
    private Long pid; // 申请单主键
    @TableField(value="one_category_id")
    private Long oneCategoryId; // 一级分类
    @TableField(value="one_category")
    private String oneCategory; // 一级分类
    @TableField(value="fee_tax_mny")
    private BigDecimal feeTaxMny; // 费用金额
    @TableField(value="fee_happen_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date feeHappenDate; // 费用发生日期
    @TableField(value="fee_memo")
    private String feeMemo; // 备注
    @TableField(value="two_category_id")
    private Long twoCategoryId; // 二级分类
    @TableField(value="two_category")
    private String twoCategory; // 二级分类
    
    
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getOneCategoryId() {
        return oneCategoryId;
    }

    public void setOneCategoryId(Long oneCategoryId) {
        this.oneCategoryId = oneCategoryId;
    }
    public String getOneCategory() {
        return oneCategory;
    }

    public void setOneCategory(String oneCategory) {
        this.oneCategory = oneCategory;
    }
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    public Date getFeeHappenDate() {
        return feeHappenDate;
    }

    public void setFeeHappenDate(Date feeHappenDate) {
        this.feeHappenDate = feeHappenDate;
    }
    public String getFeeMemo() {
        return feeMemo;
    }

    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    public Long getTwoCategoryId() {
        return twoCategoryId;
    }

    public void setTwoCategoryId(Long twoCategoryId) {
        this.twoCategoryId = twoCategoryId;
    }
    public String getTwoCategory() {
        return twoCategory;
    }

    public void setTwoCategory(String twoCategory) {
        this.twoCategory = twoCategory;
    }
    
}
