package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.OuterCertEntity;
import com.ejianc.business.tax.service.IOuterCertService;
import com.ejianc.business.tax.vo.InvoiceOpenApplyVO;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tax.mapper.InvoiceOpenApplyMapper;
import com.ejianc.business.tax.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.tax.service.IInvoiceOpenApplyService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 税务管理-开票申请
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenApplyService")
public class InvoiceOpenApplyServiceImpl extends BaseServiceImpl<InvoiceOpenApplyMapper, InvoiceOpenApplyEntity> implements IInvoiceOpenApplyService{

    @Autowired
    private IOuterCertService outerCertService;
    @Override
    public boolean queryOverOutCert(InvoiceOpenApplyVO vo) {

        LambdaQueryWrapper<OuterCertEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(OuterCertEntity::getProjectId,vo.getProjectId())
                .eq(OuterCertEntity::getDr,0)
                .in(OuterCertEntity::getBillState,1,3);
        List<OuterCertEntity> list = outerCertService.list(lambdaQueryWrapper);
        BigDecimal outCerMny = new BigDecimal("0");
        if (CollectionUtils.isNotEmpty(list)){
            outCerMny= list.stream().filter(item -> null != item.getMny()).map(OuterCertEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        LambdaQueryWrapper<InvoiceOpenApplyEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(InvoiceOpenApplyEntity::getProjectId,vo.getProjectId())
                .eq(InvoiceOpenApplyEntity::getDr,0)
                .ne(vo.getId()!=null,InvoiceOpenApplyEntity::getId,vo.getId());
        List<InvoiceOpenApplyEntity> applyEntityList = super.list(lambdaQuery);
        BigDecimal applyMny = new BigDecimal("0");
        if (CollectionUtils.isNotEmpty(applyEntityList)){
            applyMny= applyEntityList.stream().filter(item -> null != item.getApplyMnyTax()).map(InvoiceOpenApplyEntity::getApplyMnyTax)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        applyMny=ComputeUtil.safeAdd(applyMny,vo.getApplyMnyTax());
        if (ComputeUtil.isGreaterThan(applyMny,outCerMny)){
            return true;
        }
        return false;
    }

    @Override
    public boolean updOpenType(Long applyId,Integer openType) {
        LambdaUpdateWrapper<InvoiceOpenApplyEntity> invoiceOpenApplyLambdaUpdateWrapper = Wrappers.lambdaUpdate();
        invoiceOpenApplyLambdaUpdateWrapper.eq(InvoiceOpenApplyEntity::getId,applyId)
                .set(InvoiceOpenApplyEntity::getOpenType,openType);
        return  super.update(invoiceOpenApplyLambdaUpdateWrapper);

    }
}
